/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.layout.impl;

import cz.vutbr.fit.layout.model.Box;
import cz.vutbr.fit.layout.model.Color;
import cz.vutbr.fit.layout.model.Page;
import cz.vutbr.fit.layout.model.Rectangular;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseBoxTreeBuilder {
    private static Logger log = LoggerFactory.getLogger(BaseBoxTreeBuilder.class);
    private static final double AREAP = 0.8;
    protected URL pageUrl;
    protected String pageTitle;
    protected boolean useVisualBounds;
    protected boolean preserveAux;

    public BaseBoxTreeBuilder(boolean useVisualBounds, boolean preserveAux) {
        this.useVisualBounds = useVisualBounds;
        this.preserveAux = preserveAux;
    }

    public abstract Page getPage();

    protected Box buildTree(List<Box> boxlist, Color bgColor) {
        Box rootNode = boxlist.remove(0);
        if (this.useVisualBounds) {
            log.trace("A1");
            this.recomputeVisualBounds(boxlist);
            Box root = this.createBoxTree(rootNode, boxlist, true, true, true);
            log.trace("A2");
            Color bg = rootNode.getBackgroundColor();
            if (bg == null) {
                bg = Color.WHITE;
            }
            this.computeBackgrounds(root, bg);
            log.trace("A2.5");
            this.recomputeVisualBounds(root);
            log.trace("A3");
            root = this.createBoxTree(rootNode, boxlist, true, true, this.preserveAux);
            this.recomputeVisualBounds(root);
            this.recomputeBounds(root, true);
            log.trace("A4");
            return root;
        }
        Box root = this.createBoxTree(rootNode, boxlist, false, true, true);
        Color bg = bgColor;
        if (bg == null) {
            bg = Color.WHITE;
        }
        this.computeBackgrounds(root, bg);
        this.recomputeVisualBounds(root);
        this.recomputeBounds(root, false);
        return root;
    }

    private Box createBoxTree(Box root, List<Box> boxlist, boolean useBounds, boolean useVisualBounds, boolean preserveAux) {
        ArrayList<Box> list = new ArrayList<Box>(boxlist);
        root.removeAllChildren();
        for (Box node : list) {
            node.removeAllChildren();
        }
        if (!preserveAux) {
            Iterator it = list.iterator();
            while (it.hasNext()) {
                Box node;
                node = (Box)it.next();
                if (node.isVisuallySeparated() && node.isVisible()) continue;
                it.remove();
            }
        }
        ArrayList<Box> parents = new ArrayList<Box>(list.size());
        for (int i = 0; i < list.size(); ++i) {
            parents.add(null);
        }
        for (Box parent : list) {
            if (useBounds) {
                this.markNodesInside(parent, list, useVisualBounds, parents);
                continue;
            }
            this.markChildNodes(parent, list, parents);
        }
        for (int i = 0; i < list.size(); ++i) {
            if (parents.get(i) != null) continue;
            root.appendChild((Box)list.get(i));
        }
        for (Box child : root.getChildren()) {
            this.takeChildren(child, list, parents);
        }
        return root;
    }

    public void markChildNodes(Box parent, List<Box> list, List<Box> parents) {
        for (int i = 0; i < list.size(); ++i) {
            Box child = list.get(i);
            if (child == parent || child.getIntrinsicParent() == null || !child.getIntrinsicParent().equals(parent)) continue;
            parents.set(i, parent);
        }
    }

    protected void markNodesInside(Box parent, List<Box> list, boolean useVisualBounds, List<Box> parents) {
        for (int i = 0; i < list.size(); ++i) {
            Box child = list.get(i);
            if (!useVisualBounds) {
                if (child == parent || !this.contentEncloses(parent, child) || parents.get(i) != null && this.contentEncloses(parent, parents.get(i))) continue;
                parents.set(i, parent);
                continue;
            }
            if (child == parent || !this.visuallyEncloses(parent, child) || parents.get(i) != null && this.visuallyEncloses(parent, parents.get(i))) continue;
            parents.set(i, parent);
        }
    }

    protected void takeChildren(Box parent, List<Box> list, List<Box> parents) {
        for (int i = 0; i < list.size(); ++i) {
            if (!parent.equals(parents.get(i))) continue;
            parent.appendChild(list.get(i));
        }
        for (Box child : parent.getChildren()) {
            this.takeChildren(child, list, parents);
        }
    }

    protected boolean contentEncloses(Box parent, Box child) {
        if (parent.getContentBounds().encloses(child.getContentBounds())) {
            return true;
        }
        if (parent.getContentBounds().equals(child.getContentBounds())) {
            return parent.getOrder() < child.getOrder();
        }
        return false;
    }

    protected boolean visuallyEncloses(Box parent, Box child) {
        if (child.getVisualBounds().encloses(parent.getVisualBounds())) {
            return false;
        }
        int shared = parent.getVisualBounds().intersection(child.getVisualBounds()).getArea();
        double sharedperc = (double)shared / (double)child.getVisualBounds().getArea();
        return parent.getOrder() < child.getOrder() && sharedperc >= 0.8;
    }

    protected void computeBackgrounds(Box root, Color currentbg) {
        Color newbg = root.getBackgroundColor();
        if (newbg == null) {
            newbg = currentbg;
        }
        byte[] bgimg = root.getBackgroundImagePng();
        root.setBackgroundSeparated(!newbg.equals(currentbg) || bgimg != null);
        for (int i = 0; i < root.getChildCount(); ++i) {
            this.computeBackgrounds((Box)root.getChildAt(i), newbg);
        }
    }

    public void recomputeBounds(Box root, boolean useVisualBounds) {
        if (useVisualBounds) {
            root.setBounds(new Rectangular(root.getVisualBounds()));
        } else {
            root.setBounds(new Rectangular(root.getContentBounds()));
        }
        for (Box child : root.getChildren()) {
            this.recomputeBounds(child, useVisualBounds);
            root.getBounds().expandToEnclose(child.getBounds());
        }
    }

    protected void recomputeVisualBounds(List<Box> boxes) {
        for (Box box : boxes) {
            box.setVisualBounds(this.computeVisualBounds(box));
        }
    }

    protected void recomputeVisualBounds(Box root) {
        for (Box child : root.getChildren()) {
            this.recomputeVisualBounds(child);
        }
        root.setVisualBounds(this.computeVisualBounds(root));
    }

    protected Rectangular computeVisualBounds(Box box) {
        Rectangular ret = null;
        if (box.getIntrinsicParent() == null) {
            ret = box.getContentBounds();
        } else if (box.getType() == Box.Type.ELEMENT) {
            if (box.getBorderCount() == 1 && !box.isBackgroundSeparated()) {
                Rectangular b = box.getContentBounds();
                if (box.hasTopBorder()) {
                    ret = new Rectangular(b.getX1(), b.getY1(), b.getX2(), b.getY1() + box.getTopBorder() - 1);
                } else if (box.hasBottomBorder()) {
                    ret = new Rectangular(b.getX1(), b.getY2() - box.getBottomBorder() + 1, b.getX2(), b.getY2());
                } else if (box.hasLeftBorder()) {
                    ret = new Rectangular(b.getX1(), b.getY1(), b.getX1() + box.getLeftBorder() - 1, b.getY2());
                } else if (box.hasRightBorder()) {
                    ret = new Rectangular(b.getX2() - box.getRightBorder() + 1, b.getY1(), b.getX2(), b.getY2());
                }
                ret.expandToEnclose(this.getMinimalVisualBounds(box));
            } else {
                ret = box.getBorderCount() >= 2 || box.getBorderCount() == 1 && box.isBackgroundSeparated() ? new Rectangular(box.getContentBounds()) : (box.isVisuallySeparated() ? new Rectangular(box.getContentBounds()) : this.getMinimalVisualBounds(box));
            }
        } else {
            ret = this.getMinimalVisualBounds(box);
        }
        return ret;
    }

    protected Rectangular getMinimalVisualBounds(Box box) {
        if (box.getType() == Box.Type.TEXT_CONTENT || box.getType() == Box.Type.REPLACED_CONTENT) {
            return box.getContentBounds();
        }
        Rectangular ret = null;
        for (Box sub : box.getChildren()) {
            Rectangular sb = sub.getVisualBounds();
            if (!sub.isVisible() || sb.getWidth() <= 0 || sb.getHeight() <= 0) continue;
            if (ret == null) {
                ret = new Rectangular(sb);
                continue;
            }
            ret.expandToEnclose(sb);
        }
        if (ret == null) {
            Rectangular b = box.getContentBounds();
            return new Rectangular(b.getX1(), b.getY1());
        }
        return ret;
    }
}

