/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.layout.api;

import cz.vutbr.fit.layout.api.AreaConcatenator;
import cz.vutbr.fit.layout.api.BoxConcatenator;
import cz.vutbr.fit.layout.model.Area;
import cz.vutbr.fit.layout.model.Box;
import java.util.List;
import java.util.stream.Collectors;

public class Concatenators {
    private static BoxConcatenator defaultBoxConcatenator = new SeparatedBoxConcatenator(" ");
    private static AreaConcatenator defaultAreaConcatenator = new PlainAreaConcatenator(defaultBoxConcatenator);

    public static BoxConcatenator getDefaultBoxConcatenator() {
        return defaultBoxConcatenator;
    }

    public static AreaConcatenator getDefaultAreaConcatenator() {
        return defaultAreaConcatenator;
    }

    public static class SeparatedAreaConcatenator
    implements AreaConcatenator {
        private String separator;
        private BoxConcatenator boxConcatenator;

        public SeparatedAreaConcatenator(String separator, BoxConcatenator boxConcatenator) {
            this.separator = separator;
            this.boxConcatenator = boxConcatenator;
        }

        @Override
        public String concat(List<Area> elems) {
            return elems.stream().map(b -> b.getText(this)).collect(Collectors.joining(this.separator));
        }

        @Override
        public BoxConcatenator getBoxConcatenator() {
            return this.boxConcatenator;
        }
    }

    public static class PlainAreaConcatenator
    implements AreaConcatenator {
        private BoxConcatenator boxConcatenator;

        public PlainAreaConcatenator(BoxConcatenator boxConcatenator) {
            this.boxConcatenator = boxConcatenator;
        }

        @Override
        public String concat(List<Area> elems) {
            return elems.stream().map(a -> a.getText(this)).collect(Collectors.joining());
        }

        @Override
        public BoxConcatenator getBoxConcatenator() {
            return this.boxConcatenator;
        }
    }

    public static class SeparatedBoxConcatenator
    implements BoxConcatenator {
        private String separator;

        public SeparatedBoxConcatenator(String separator) {
            this.separator = separator;
        }

        @Override
        public String concat(List<Box> elems) {
            return elems.stream().map(b -> b.getText(this)).collect(Collectors.joining(this.separator));
        }
    }

    public static class PlainBoxConcatenator
    implements BoxConcatenator {
        @Override
        public String concat(List<Box> elems) {
            return elems.stream().map(b -> b.getText(this)).collect(Collectors.joining());
        }
    }
}

