/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.layout.impl;

import cz.vutbr.fit.layout.api.OutputDisplay;
import cz.vutbr.fit.layout.model.AreaTopology;
import cz.vutbr.fit.layout.model.ContentRect;
import cz.vutbr.fit.layout.model.Rectangular;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jsi.Area;
import net.sf.jsi.AreaCallback;
import net.sf.jsi.RTree;
import net.sf.jsi.Spot;

public class AreaListPixelTopology
implements AreaTopology {
    private List<ContentRect> areas;
    private Rectangular abspos;
    private Map<ContentRect, Rectangular> positions;
    private RTree areaRTree;

    public AreaListPixelTopology(List<ContentRect> areas, Rectangular abspos) {
        this(areas, abspos, true);
    }

    public AreaListPixelTopology(List<ContentRect> areas, Rectangular abspos, boolean doInit) {
        this.areas = areas;
        this.abspos = abspos;
        if (doInit) {
            this.update();
        }
    }

    @Override
    public Collection<ContentRect> getAreas() {
        return this.areas;
    }

    public void setAreas(List<ContentRect> areas) {
        this.areas = areas;
    }

    @Override
    public int getTopologyWidth() {
        return this.abspos.getWidth();
    }

    @Override
    public int getTopologyHeight() {
        return this.abspos.getHeight();
    }

    @Override
    public Rectangular getTopologyPosition() {
        return this.abspos;
    }

    @Override
    public Rectangular getPosition(ContentRect area) {
        return this.positions.get(area);
    }

    @Override
    public void setPosition(ContentRect area, Rectangular gp) {
        this.positions.put(area, gp);
    }

    @Override
    public Map<ContentRect, Rectangular> getPositionMap() {
        return this.positions;
    }

    @Override
    public ContentRect findAreaAt(int x, int y) {
        AreaMatch match = new AreaMatch(false);
        this.areaRTree.nearest(new Spot((float)x, (float)y), (AreaCallback)match, 0.05f);
        if (!match.getRects().isEmpty()) {
            return match.getRects().get(0);
        }
        return null;
    }

    @Override
    public Collection<ContentRect> findAllAreasAt(int x, int y) {
        AreaMatch match = new AreaMatch(true);
        this.areaRTree.nearest(new Spot((float)x, (float)y), (AreaCallback)match, 0.05f);
        return match.getRects();
    }

    @Override
    public Collection<ContentRect> findAllAreasIntersecting(Rectangular r) {
        Area query = new Area((float)r.getX1(), (float)r.getY1(), (float)r.getX2(), (float)r.getY2());
        AreaMatch match = new AreaMatch(true);
        this.areaRTree.intersects(query, (AreaCallback)match);
        return match.getRects();
    }

    @Override
    public Rectangular toPixelPosition(Rectangular pos) {
        return pos;
    }

    @Override
    public Rectangular toPixelPositionAbsolute(Rectangular gp) {
        Rectangular ret = new Rectangular(gp);
        ret.move(this.abspos.getX1(), this.abspos.getY1());
        return ret;
    }

    @Override
    public int toTopologyX(int pixelX) {
        return pixelX;
    }

    @Override
    public int toTopologyY(int pixelY) {
        return pixelY;
    }

    @Override
    public void update() {
        this.positions = new HashMap<ContentRect, Rectangular>(this.areas.size());
        for (ContentRect a : this.areas) {
            this.positions.put(a, new Rectangular());
        }
        this.updateIndex();
    }

    @Override
    public void drawLayout(OutputDisplay disp) {
    }

    protected void updateIndex() {
        this.areaRTree = new RTree();
        for (int i = 0; i < this.areas.size(); ++i) {
            ContentRect rect = this.areas.get(i);
            Area area = new Area((float)rect.getX1(), (float)rect.getY1(), (float)rect.getX2(), (float)rect.getY2());
            this.areaRTree.add(area, i);
        }
    }

    class AreaMatch
    implements AreaCallback {
        private final List<ContentRect> rects = new ArrayList<ContentRect>();
        private final boolean processAll;

        public AreaMatch(boolean processAll) {
            this.processAll = processAll;
        }

        public boolean processArea(int id) {
            this.rects.add(AreaListPixelTopology.this.areas.get(id));
            return this.processAll;
        }

        public List<ContentRect> getRects() {
            return this.rects;
        }
    }
}

