/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.layout.impl;

import cz.vutbr.fit.layout.api.Parameter;
import cz.vutbr.fit.layout.api.ParametrizedOperation;
import cz.vutbr.fit.layout.impl.BaseService;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseParametrizedOperation
extends BaseService
implements ParametrizedOperation {
    private static Logger log = LoggerFactory.getLogger(BaseParametrizedOperation.class);
    private List<Parameter> params;

    @Override
    public List<Parameter> getParams() {
        if (this.params == null) {
            this.params = this.defineParams();
        }
        return this.params;
    }

    public List<Parameter> defineParams() {
        return Collections.emptyList();
    }

    @Override
    public boolean setParam(String name, Object value) {
        String sname = "set" + name.substring(0, 1).toUpperCase() + name.substring(1);
        try {
            if (value instanceof Integer) {
                Method m = this.getClass().getMethod(sname, Integer.TYPE);
                m.invoke((Object)this, value);
            } else if (value instanceof Double) {
                try {
                    Method m = this.getClass().getMethod(sname, Float.TYPE);
                    m.invoke((Object)this, Float.valueOf(((Double)value).floatValue()));
                }
                catch (NoSuchMethodException e) {
                    Method m = this.getClass().getMethod(sname, Integer.TYPE);
                    m.invoke((Object)this, ((Double)value).intValue());
                }
            } else if (value instanceof Float) {
                try {
                    Method m = this.getClass().getMethod(sname, Float.TYPE);
                    m.invoke((Object)this, value);
                }
                catch (NoSuchMethodException e) {
                    Method m = this.getClass().getMethod(sname, Integer.TYPE);
                    m.invoke((Object)this, ((Double)value).intValue());
                }
            } else if (value instanceof Boolean) {
                Method m = this.getClass().getMethod(sname, Boolean.TYPE);
                m.invoke((Object)this, value);
            } else {
                try {
                    Method m = this.getClass().getMethod(sname, String.class);
                    m.invoke((Object)this, value.toString());
                    return true;
                }
                catch (NoSuchMethodException e) {
                    try {
                        int n = Integer.parseInt(value.toString());
                        Method m = this.getClass().getMethod(sname, Integer.TYPE);
                        m.invoke((Object)this, n);
                        return true;
                    }
                    catch (NumberFormatException n) {
                    }
                    catch (NoSuchMethodException n) {
                        // empty catch block
                    }
                    try {
                        float n = Float.parseFloat(value.toString());
                        Method m = this.getClass().getMethod(sname, Float.TYPE);
                        m.invoke((Object)this, Float.valueOf(n));
                        return true;
                    }
                    catch (NumberFormatException n) {
                    }
                    catch (NoSuchMethodException n) {
                        // empty catch block
                    }
                    try {
                        boolean b = Boolean.parseBoolean(value.toString());
                        Method m = this.getClass().getMethod(sname, Boolean.TYPE);
                        m.invoke((Object)this, b);
                        return true;
                    }
                    catch (NoSuchMethodException b) {
                        // empty catch block
                    }
                }
            }
            return true;
        }
        catch (NoSuchMethodException e) {
            log.warn("Setting unknown parameter: " + e.getMessage());
            return false;
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return false;
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            return false;
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public Object getParam(String name) {
        String sname = "get" + name.substring(0, 1).toUpperCase() + name.substring(1);
        try {
            Method m = this.getClass().getMethod(sname, new Class[0]);
            return m.invoke((Object)this, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        catch (SecurityException e) {
            e.printStackTrace();
            return null;
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return null;
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            return null;
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public String getParamString() {
        StringBuilder ret = new StringBuilder();
        for (Parameter param : this.getParams()) {
            Object val;
            if (ret.length() != 0) {
                ret.append(' ');
            }
            if ((val = this.getParam(param.getName())) == null) continue;
            ret.append(param.getName()).append('=').append(val.toString());
        }
        return ret.toString();
    }
}

