/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.layout.impl;

import cz.vutbr.fit.layout.api.BoxConcatenator;
import cz.vutbr.fit.layout.api.Concatenators;
import cz.vutbr.fit.layout.impl.DefaultTreeContentRect;
import cz.vutbr.fit.layout.model.Box;
import cz.vutbr.fit.layout.model.Color;
import cz.vutbr.fit.layout.model.ContentObject;
import cz.vutbr.fit.layout.model.Page;
import cz.vutbr.fit.layout.model.Rectangular;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.rdf4j.model.IRI;

public class DefaultBox
extends DefaultTreeContentRect<Box>
implements Box {
    private Page page;
    private int order;
    private boolean visible;
    private Color color;
    private String fontFamily;
    private String text;
    private ContentObject contentObject;
    private Rectangular contentBounds;
    private Rectangular visualBounds;
    private Box intrinsicParent;
    private String sourceNodeId;
    private String tagName;
    private Map<String, String> attributes;
    private Box.Type type;
    private Box.DisplayType displayType;

    public DefaultBox() {
        super(Box.class);
        this.visible = true;
        this.text = "";
        this.color = Color.BLACK;
        this.fontFamily = "none";
        this.tagName = "none";
        this.type = Box.Type.ELEMENT;
        this.displayType = Box.DisplayType.BLOCK;
    }

    public DefaultBox(Box src) {
        super(Box.class, src);
        this.order = src.getOrder();
        this.visible = src.isVisible();
        this.color = new Color(src.getColor().getRed(), src.getColor().getGreen(), src.getColor().getBlue(), src.getColor().getAlpha());
        this.fontFamily = new String(src.getFontFamily());
        if (src.getOwnText() != null) {
            this.text = new String(src.getOwnText());
        }
        this.contentObject = src.getContentObject();
        this.contentBounds = src.getContentBounds() == null ? null : new Rectangular(src.getContentBounds());
        this.visualBounds = src.getVisualBounds() == null ? null : new Rectangular(src.getVisualBounds());
        this.sourceNodeId = src.getSourceNodeId();
        String string = this.tagName = src.getTagName() == null ? null : new String(src.getTagName());
        if (src.getAttributes() != null) {
            this.attributes = new HashMap<String, String>(src.getAttributes());
        }
        this.type = src.getType();
        this.displayType = src.getDisplayType();
    }

    @Override
    public Page getPage() {
        return this.page;
    }

    public void setPage(Page page) {
        this.page = page;
    }

    @Override
    public IRI getPageIri() {
        if (this.page == null) {
            return null;
        }
        return this.page.getIri();
    }

    @Override
    public void setPageIri(IRI pageIri) {
        throw new IllegalArgumentException("box.setPageIri() should cannot be used, use setPage() instead");
    }

    @Override
    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    @Override
    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    @Override
    public String getFontFamily() {
        return this.fontFamily;
    }

    public void setFontFamily(String fontFamily) {
        this.fontFamily = fontFamily;
    }

    @Override
    public String getText() {
        return this.getText(Concatenators.getDefaultBoxConcatenator());
    }

    @Override
    public String getText(BoxConcatenator concatenator) {
        if (this.isLeaf()) {
            return this.getOwnText();
        }
        return concatenator.concat(this.getChildren());
    }

    @Override
    public String getOwnText() {
        if (this.isLeaf()) {
            return this.text;
        }
        return null;
    }

    public void setOwnText(String text) {
        this.text = text;
    }

    @Override
    public ContentObject getContentObject() {
        return this.contentObject;
    }

    public void setContentObject(ContentObject contentObject) {
        this.contentObject = contentObject;
    }

    @Override
    public Rectangular getContentBounds() {
        return this.contentBounds;
    }

    @Override
    public void setContentBounds(Rectangular contentBounds) {
        this.contentBounds = contentBounds;
    }

    @Override
    public Rectangular getVisualBounds() {
        return this.visualBounds;
    }

    @Override
    public void setVisualBounds(Rectangular visualBounds) {
        this.visualBounds = visualBounds;
    }

    @Override
    public Rectangular getSubstringBounds(int startPos, int endPos) {
        String t = this.getOwnText();
        if (t != null) {
            Rectangular ret = new Rectangular(this.getContentBounds());
            float step = (float)ret.getWidth() / (float)t.length();
            int origin = ret.getX1();
            ret.setX1(origin + Math.round((float)startPos * step));
            ret.setX2(origin + Math.round((float)endPos * step));
            return ret;
        }
        return null;
    }

    @Override
    public Box getIntrinsicParent() {
        return this.intrinsicParent;
    }

    public void setIntrinsicParent(Box intrinsicParent) {
        this.intrinsicParent = intrinsicParent;
    }

    @Override
    public String getSourceNodeId() {
        return this.sourceNodeId;
    }

    public void setSourceNodeId(String sourceNodeId) {
        this.sourceNodeId = sourceNodeId;
    }

    @Override
    public String getTagName() {
        return this.tagName;
    }

    public void setTagName(String tagName) {
        this.tagName = tagName;
    }

    @Override
    public String getAttribute(String name) {
        if (this.attributes != null) {
            return this.attributes.get(name);
        }
        return null;
    }

    @Override
    public Map<String, String> getAttributes() {
        if (this.attributes != null) {
            return this.attributes;
        }
        return Collections.emptyMap();
    }

    public void setAttribute(String name, String value) {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, String>();
        }
        this.attributes.put(name, value);
    }

    public void removeAttribute(String name) {
        if (this.attributes != null) {
            this.attributes.remove(name);
        }
    }

    @Override
    public Box.Type getType() {
        return this.type;
    }

    public void setType(Box.Type type) {
        this.type = type;
    }

    @Override
    public Box.DisplayType getDisplayType() {
        return this.displayType;
    }

    public void setDisplayType(Box.DisplayType displayType) {
        this.displayType = displayType;
    }

    @Override
    public int getX1() {
        return this.getVisualBounds().getX1();
    }

    @Override
    public int getY1() {
        return this.getVisualBounds().getY1();
    }

    @Override
    public int getX2() {
        return this.getVisualBounds().getX2();
    }

    @Override
    public int getY2() {
        return this.getVisualBounds().getY2();
    }

    @Override
    public int getWidth() {
        return this.getVisualBounds().getWidth();
    }

    @Override
    public int getHeight() {
        return this.getVisualBounds().getHeight();
    }

    @Override
    public void move(int xofs, int yofs) {
        this.getVisualBounds().move(xofs, yofs);
        this.getContentBounds().move(xofs, yofs);
        super.move(xofs, yofs);
    }

    public String toString() {
        StringBuilder ret = new StringBuilder();
        switch (this.type) {
            case ELEMENT: 
            case REPLACED_CONTENT: {
                ret.append("<").append(this.getTagName());
                if (this.getAttribute("id") != null) {
                    ret.append(" id=").append(this.getAttribute("id"));
                }
                if (this.getAttribute("class") != null) {
                    ret.append(" class=").append(this.getAttribute("class"));
                }
                ret.append(">");
                if (this.type != Box.Type.REPLACED_CONTENT) break;
                if (this.getContentObject() == null) {
                    ret.append(" [replaced]");
                    break;
                }
                ret.append(" [replaced:{").append(this.getContentObject().toString()).append("}]");
                break;
            }
            case TEXT_CONTENT: {
                ret.append("Text: ").append(this.getText());
            }
        }
        return ret.toString();
    }

    @Override
    public boolean isVisuallySeparated() {
        if (!this.isVisible()) {
            return false;
        }
        if (this.getType() == Box.Type.TEXT_CONTENT) {
            return !this.getText().trim().isEmpty();
        }
        if (this.getType() == Box.Type.REPLACED_CONTENT) {
            return true;
        }
        if (this.getDisplayType() == Box.DisplayType.LIST_ITEM) {
            return true;
        }
        if (this.getBorderCount() >= 1) {
            return true;
        }
        return this.isBackgroundSeparated();
    }

    @Override
    protected void recomputeTextStyle() {
        if (!this.isLeaf()) {
            this.getTextStyle().reset();
            for (Box box : this.getChildren()) {
                this.getTextStyle().updateAverages(box.getTextStyle());
            }
        }
    }
}

