/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.layout.impl;

import cz.vutbr.fit.layout.model.Area;
import cz.vutbr.fit.layout.model.ContentLine;
import cz.vutbr.fit.layout.model.ContentRect;
import java.util.ArrayList;
import java.util.Collection;

public class DefaultContentLine
extends ArrayList<ContentRect>
implements ContentLine {
    private static final long serialVersionUID = 1L;

    public DefaultContentLine() {
    }

    public DefaultContentLine(int size) {
        super(size);
    }

    public DefaultContentLine(Collection<? extends Area> src) {
        super(src);
        for (Area area : src) {
            area.setLine(this);
        }
    }

    @Override
    public ContentRect getAreaBefore(ContentRect area) {
        int i = this.indexOf(area);
        return i > 0 ? (ContentRect)this.get(i - 1) : null;
    }

    @Override
    public ContentRect getAreaAfter(ContentRect area) {
        int i = this.indexOf(area);
        return i != -1 && i + 1 < this.size() ? (ContentRect)this.get(i + 1) : null;
    }

    @Override
    public boolean add(ContentRect area) {
        area.setLine(this);
        return super.add(area);
    }

    @Override
    public void add(int index, ContentRect area) {
        area.setLine(this);
        super.add(index, area);
    }

    @Override
    public boolean addAll(Collection<? extends ContentRect> c) {
        for (ContentRect contentRect : c) {
            contentRect.setLine(this);
        }
        return super.addAll(c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends ContentRect> c) {
        for (ContentRect contentRect : c) {
            contentRect.setLine(this);
        }
        return super.addAll(index, c);
    }
}

