/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.layout.impl;

import cz.vutbr.fit.layout.api.IRIDecoder;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;

public class DefaultIRIDecoder
implements IRIDecoder {
    private Map<String, String> prefixUris = new HashMap<String, String>();
    private Map<String, String> uriPrefixes = new HashMap<String, String>();

    public DefaultIRIDecoder() {
        this.initPrefixes();
    }

    protected void initPrefixes() {
        this.addPrefix("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
        this.addPrefix("rdfs", "http://www.w3.org/2000/01/rdf-schema#");
        this.addPrefix("box", "http://fitlayout.github.io/ontology/render.owl#");
        this.addPrefix("segm", "http://fitlayout.github.io/ontology/segmentation.owl#");
        this.addPrefix("map", "http://fitlayout.github.io/ontology/mapping.owl#");
        this.addPrefix("fl", "http://fitlayout.github.io/ontology/fitlayout.owl#");
        this.addPrefix("flfn", "http://fitlayout.github.io/fn/");
    }

    public void addPrefix(String prefix, String uri) {
        this.prefixUris.put(prefix, uri);
        this.uriPrefixes.put(uri, prefix);
    }

    @Override
    public Map<String, String> getPrefixUris() {
        return this.prefixUris;
    }

    public Map<String, String> getUriPrefixes() {
        return this.uriPrefixes;
    }

    @Override
    public String declarePrefixes() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> entry : this.prefixUris.entrySet()) {
            sb.append("PREFIX ").append(entry.getKey()).append(": <").append(entry.getValue()).append("> ");
        }
        return sb.toString();
    }

    @Override
    public String encodeIri(IRI iri) {
        String ret = String.valueOf(iri);
        for (Map.Entry<String, String> entry : this.uriPrefixes.entrySet()) {
            if (!ret.startsWith(entry.getKey())) continue;
            ret = ret.replace(entry.getKey(), entry.getValue() + ":");
            break;
        }
        return ret;
    }

    @Override
    public IRI decodeIri(String shortIri) throws IllegalArgumentException {
        String ret = shortIri;
        for (Map.Entry<String, String> entry : this.prefixUris.entrySet()) {
            if (!ret.startsWith(entry.getKey() + ":")) continue;
            ret = ret.replace(entry.getKey() + ":", entry.getValue());
            break;
        }
        SimpleValueFactory vf = SimpleValueFactory.getInstance();
        return vf.createIRI(ret);
    }
}

