/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.layout.impl;

import cz.vutbr.fit.layout.impl.BaseArtifact;
import cz.vutbr.fit.layout.impl.DefaultBox;
import cz.vutbr.fit.layout.model.Box;
import cz.vutbr.fit.layout.model.Page;
import cz.vutbr.fit.layout.model.Rectangular;
import cz.vutbr.fit.layout.ontology.BOX;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.rdf4j.model.IRI;

public class DefaultPage
extends BaseArtifact
implements Page {
    private int boxIdCnt = 1;
    protected URL url;
    protected String title;
    protected Box root;
    protected int width;
    protected int height;
    protected byte[] pngImage;

    public DefaultPage(URL url) {
        super(null);
        this.url = url;
    }

    public DefaultPage(Page src) {
        super(null, src);
        this.url = src.getSourceURL();
        if (src.getTitle() != null) {
            this.title = new String(src.getTitle());
        }
        this.root = src.getRoot();
        this.width = src.getWidth();
        this.height = src.getHeight();
        this.pngImage = src.getPngImage();
    }

    @Override
    public IRI getArtifactType() {
        return BOX.Page;
    }

    @Override
    public URL getSourceURL() {
        return this.url;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public Box getRoot() {
        return this.root;
    }

    public void setRoot(Box root) {
        this.root = root;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    @Override
    public byte[] getPngImage() {
        return this.pngImage;
    }

    public void setPngImage(byte[] pngImage) {
        this.pngImage = pngImage;
    }

    @Override
    public List<Box> getBoxesAt(int x, int y) {
        ArrayList<Box> ret = new ArrayList<Box>();
        this.recursiveGetBoxesAt(this.root, x, y, ret);
        return ret;
    }

    private void recursiveGetBoxesAt(Box root, int x, int y, List<Box> dest) {
        if (root.getBounds().contains(x, y)) {
            dest.add(root);
            for (int i = 0; i < root.getChildCount(); ++i) {
                this.recursiveGetBoxesAt((Box)root.getChildAt(i), x, y, dest);
            }
        }
    }

    @Override
    public List<Box> getBoxesInRegion(Rectangular r) {
        ArrayList<Box> ret = new ArrayList<Box>();
        this.recursiveGetBoxesInRegion(this.root, r, ret);
        return ret;
    }

    private void recursiveGetBoxesInRegion(Box root, Rectangular r, List<Box> result) {
        if (r.encloses(root.getVisualBounds())) {
            if (!root.getVisualBounds().isEmpty()) {
                result.add(root);
            }
        } else {
            for (int i = 0; i < root.getChildCount(); ++i) {
                this.recursiveGetBoxesInRegion((Box)root.getChildAt(i), r, result);
            }
        }
    }

    public String toString() {
        Object ret = "";
        ret = this.getSourceURL() != null ? (String)ret + this.getSourceURL().toString() : (String)ret + "- unknown URL -";
        ret = (String)ret + " [" + this.getIri() + "]";
        return ret;
    }

    @Override
    public Box createBox() {
        DefaultBox ret = new DefaultBox();
        ret.setId(this.getNextBoxId());
        ret.setPage(this);
        return ret;
    }

    @Override
    public Box createBox(Box src) {
        DefaultBox ret = new DefaultBox(src);
        ret.setId(this.getNextBoxId());
        ret.setPage(this);
        return ret;
    }

    protected int getNextBoxId() {
        return this.boxIdCnt++;
    }
}

