/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.layout.io;

import cz.vutbr.fit.layout.api.OutputDisplay;
import cz.vutbr.fit.layout.io.BorderStroke;
import cz.vutbr.fit.layout.model.Area;
import cz.vutbr.fit.layout.model.Border;
import cz.vutbr.fit.layout.model.Box;
import cz.vutbr.fit.layout.model.Color;
import cz.vutbr.fit.layout.model.ContentImage;
import cz.vutbr.fit.layout.model.ContentObject;
import cz.vutbr.fit.layout.model.ContentRect;
import cz.vutbr.fit.layout.model.Page;
import cz.vutbr.fit.layout.model.Rectangular;
import cz.vutbr.fit.layout.model.Tag;
import java.awt.AlphaComposite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.font.TextAttribute;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.text.AttributedString;
import java.util.HashMap;
import java.util.Set;
import javax.imageio.ImageIO;

public class Graphics2DDisplay
implements OutputDisplay {
    private Graphics2D g;
    private java.awt.Color boxLogicalColor = java.awt.Color.RED;
    private java.awt.Color boxContentColor = java.awt.Color.GREEN;
    private java.awt.Color areaBoundsColor = java.awt.Color.MAGENTA;

    public Graphics2DDisplay(Graphics2D g) {
        this.g = g;
    }

    public Graphics2D getGraphics() {
        return this.g;
    }

    public void setGraphics(Graphics2D g) {
        this.g = g;
    }

    public void drawPage(Page page) {
        this.setupGraphics();
        this.recursivelyDrawBoxes(page.getRoot());
    }

    public void drawPage(Page page, boolean bitmap) {
        this.setupGraphics();
        if (bitmap) {
            this.drawScreenShot(page.getPngImage());
        } else {
            this.recursivelyDrawBoxes(page.getRoot());
        }
    }

    private void recursivelyDrawBoxes(Box root) {
        this.drawBox(root);
        for (int i = 0; i < root.getChildCount(); ++i) {
            this.recursivelyDrawBoxes((Box)root.getChildAt(i));
        }
    }

    public void drawBox(Box box) {
        Box.Type type = box.getType();
        if (type == Box.Type.TEXT_CONTENT) {
            this.g.setColor(this.toAWTColor(box.getColor()));
            String fmlspec = box.getFontFamily();
            float fontsize = box.getTextStyle().getFontSize();
            int fs = 0;
            if (box.getTextStyle().getFontWeight() > 0.5f) {
                fs = 1;
            }
            if (box.getTextStyle().getFontStyle() > 0.5f) {
                fs |= 2;
            }
            Font font = new Font(fmlspec, fs, (int)fontsize);
            HashMap<TextAttribute, Integer> attributes = new HashMap<TextAttribute, Integer>();
            attributes.put(TextAttribute.KERNING, TextAttribute.KERNING_ON);
            font = font.deriveFont(attributes);
            this.g.setFont(font);
            String text = box.getText();
            if (text.length() > 0) {
                AttributedString as = new AttributedString(text);
                as.addAttribute(TextAttribute.FONT, font);
                if (box.getTextStyle().getUnderline() > 0.5f) {
                    as.addAttribute(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
                }
                if (box.getTextStyle().getLineThrough() > 0.5f) {
                    as.addAttribute(TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON);
                }
                FontMetrics fm = this.g.getFontMetrics();
                Rectangle2D rect = fm.getStringBounds(text, this.g);
                int x = box.getX1() + (int)rect.getX();
                int y = box.getY1() - (int)rect.getY();
                this.g.drawString(as.getIterator(), x, y);
            }
        } else if (type == Box.Type.REPLACED_CONTENT) {
            ContentObject obj = box.getContentObject();
            if (obj != null && obj instanceof ContentImage && ((ContentImage)obj).getPngData() != null) {
                try {
                    byte[] pngData = ((ContentImage)obj).getPngData();
                    BufferedImage image = ImageIO.read(new ByteArrayInputStream(pngData));
                    this.g.drawImage((Image)image, box.getBounds().getX1(), box.getBounds().getY1(), null);
                }
                catch (IOException pngData) {}
            } else {
                this.g.setColor(this.toAWTColor(box.getColor()));
                Rectangular r = box.getBounds();
                this.g.drawRect(r.getX1(), r.getY1(), r.getWidth() - 1, r.getHeight() - 1);
            }
        } else {
            Border bst;
            Rectangular r = box.getBounds();
            java.awt.Color bg = this.toAWTColor(box.getBackgroundColor());
            if (bg != null) {
                this.g.setColor(bg);
                this.g.fillRect(r.getX1(), r.getY1(), r.getWidth() - 1, r.getHeight() - 1);
            }
            if (box.getBackgroundImagePng() != null) {
                try {
                    BufferedImage image = ImageIO.read(new ByteArrayInputStream(box.getBackgroundImagePng()));
                    this.g.drawImage((Image)image, r.getX1(), r.getY1(), null);
                }
                catch (IOException image) {
                    // empty catch block
                }
            }
            Stroke oldStroke = this.g.getStroke();
            if (box.hasTopBorder()) {
                bst = box.getBorderStyle(Border.Side.TOP);
                this.drawBorder(this.g, r.getX1(), r.getY1(), r.getX2(), r.getY1(), bst.getWidth(), 0, 0, bst, false);
            }
            if (box.hasRightBorder()) {
                bst = box.getBorderStyle(Border.Side.RIGHT);
                this.drawBorder(this.g, r.getX2(), r.getY1(), r.getX2(), r.getY2(), bst.getWidth(), -bst.getWidth() + 1, 0, bst, true);
            }
            if (box.hasBottomBorder()) {
                bst = box.getBorderStyle(Border.Side.BOTTOM);
                this.drawBorder(this.g, r.getX1(), r.getY2(), r.getX2(), r.getY2(), bst.getWidth(), 0, -bst.getWidth() + 1, bst, true);
            }
            if (box.hasLeftBorder()) {
                bst = box.getBorderStyle(Border.Side.LEFT);
                this.drawBorder(this.g, r.getX1(), r.getY1(), r.getX1(), r.getY2(), bst.getWidth(), 0, 0, bst, false);
            }
            this.g.setStroke(oldStroke);
        }
    }

    private void drawBorder(Graphics2D g, int x1, int y1, int x2, int y2, int width, int right, int down, Border style, boolean reverse) {
        if (style.getWidth() >= 1) {
            g.setColor(this.toAWTColor(style.getColor()));
            g.setStroke(new BorderStroke(width, style.getStyle(), reverse));
            g.draw(new Line2D.Double(x1 + right, y1 + down, x2 + right, y2 + down));
        }
    }

    private void drawScreenShot(byte[] data) {
        if (data != null) {
            try {
                BufferedImage image = ImageIO.read(new ByteArrayInputStream(data));
                this.g.drawImage((Image)image, 0, 0, null);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void drawExtent(Box box) {
        this.g.setColor(this.boxLogicalColor);
        Rectangular r = box.getBounds();
        this.g.drawRect(r.getX1(), r.getY1(), r.getWidth() - 1, r.getHeight() - 1);
        this.g.setColor(this.boxContentColor);
        r = box.getVisualBounds();
        this.g.drawRect(r.getX1(), r.getY1(), r.getWidth() - 1, r.getHeight() - 1);
    }

    public void drawExtent(Area area) {
        Rectangular bounds = area.getBounds();
        java.awt.Color c = this.g.getColor();
        this.g.setColor(this.areaBoundsColor);
        this.g.drawRect(bounds.getX1(), bounds.getY1(), bounds.getWidth() - 1, bounds.getHeight() - 1);
        this.g.setColor(c);
    }

    public void drawRectangle(Rectangular rect, java.awt.Color color) {
        java.awt.Color c = this.g.getColor();
        this.g.setColor(color);
        this.g.fillRect(rect.getX1(), rect.getY1(), rect.getWidth(), rect.getHeight());
        this.g.setColor(c);
    }

    public void drawConnection(ContentRect a1, ContentRect a2, java.awt.Color color) {
        java.awt.Color c = this.g.getColor();
        this.g.setColor(color);
        this.g.drawLine(a1.getBounds().midX(), a1.getBounds().midY(), a2.getBounds().midX(), a2.getBounds().midY());
        this.g.setColor(c);
    }

    public void colorizeByTags(ContentRect rect, Set<Tag> s) {
        if (!s.isEmpty()) {
            Rectangular bounds = rect.getBounds();
            java.awt.Color c = this.g.getColor();
            float step = (float)bounds.getHeight() / (float)s.size();
            float y = bounds.getY1();
            for (Tag tag : s) {
                this.g.setColor(this.stringColor(tag.getName()));
                this.g.fillRect(bounds.getX1(), (int)y, bounds.getWidth(), (int)((double)step + 0.5));
                y += step;
            }
            this.g.setColor(c);
        }
    }

    public void clearArea(int x, int y, int width, int height) {
        this.g.setComposite(AlphaComposite.Clear);
        this.g.fillRect(x, y, width, height);
        this.g.setComposite(AlphaComposite.SrcOver);
    }

    public void colorizeByClass(ContentRect rect, String cname) {
        if (cname != null && !cname.equals("") && !cname.equals("none")) {
            Rectangular bounds = rect.getBounds();
            java.awt.Color c = this.g.getColor();
            float step = bounds.getHeight();
            float y = bounds.getY1();
            this.g.setColor(this.stringColor(cname));
            this.g.fillRect(bounds.getX1(), (int)y, bounds.getWidth(), (int)((double)step + 0.5));
            this.g.setColor(c);
        }
    }

    protected void setupGraphics() {
        this.g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        this.g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        this.g.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
    }

    protected java.awt.Color stringColor(String cname) {
        if (cname == null || cname.equals("")) {
            return java.awt.Color.WHITE;
        }
        Object s = new String(cname);
        while (((String)s).length() < 6) {
            s = (String)s + (String)s;
        }
        int r = ((String)s).charAt(0) * ((String)s).charAt(1);
        int g = ((String)s).charAt(2) * ((String)s).charAt(3);
        int b = ((String)s).charAt(4) * ((String)s).charAt(5);
        java.awt.Color ret = new java.awt.Color(100 + r % 150, 100 + g % 150, 100 + b % 150, 128);
        return ret;
    }

    private java.awt.Color toAWTColor(Color src) {
        if (src == null) {
            return null;
        }
        return new java.awt.Color(src.getRed(), src.getGreen(), src.getBlue(), src.getAlpha());
    }
}

