/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.layout.io;

import cz.vutbr.fit.layout.model.Box;
import cz.vutbr.fit.layout.model.Color;
import cz.vutbr.fit.layout.model.Page;
import java.io.PrintWriter;

public class XMLBoxOutput {
    protected boolean produceHeader;

    public XMLBoxOutput(boolean produceHeader) {
        this.produceHeader = produceHeader;
    }

    public void dumpTo(Page tree, PrintWriter out) {
        if (this.produceHeader) {
            out.println("<?xml version=\"1.0\"?>");
        }
        out.println("<page>");
        this.recursiveDump(tree.getRoot(), 1, out);
        out.println("</page>");
    }

    private void recursiveDump(Box root, int level, PrintWriter out) {
        String tagName = root.getTagName() != null ? root.getTagName() : "#text";
        String stag = "<box tagName=\"" + tagName + "\" positionX=\"" + root.getBounds().getX1() + "\" positionY=\"" + root.getBounds().getY1() + "\" width=\"" + root.getBounds().getWidth() + "\" height=\"" + root.getBounds().getHeight() + "\" contentX=\"" + root.getContentBounds().getX1() + "\" contentY=\"" + root.getContentBounds().getY1() + "\" contentWidth=\"" + root.getContentBounds().getWidth() + "\" contentHeight=\"" + root.getContentBounds().getHeight() + "\" visualX=\"" + root.getVisualBounds().getX1() + "\" visualY=\"" + root.getVisualBounds().getY1() + "\" visualWidth=\"" + root.getVisualBounds().getWidth() + "\" visualHeight=\"" + root.getVisualBounds().getHeight() + "\" color=\"" + this.colorString(root.getColor()) + "\" bgcolor=\"" + this.colorString(root.getBackgroundColor()) + "\" fontfamily=\"" + root.getFontFamily() + "\" fontsize=\"" + root.getTextStyle().getFontSize() + "\" fontweight=\"" + root.getTextStyle().getFontWeight() + "\" fontstyle=\"" + root.getTextStyle().getFontStyle() + "\" underline=\"" + root.getTextStyle().getUnderline() + "\" linethrough=\"" + root.getTextStyle().getLineThrough() + "\" replaced=\"" + (root.getType() == Box.Type.REPLACED_CONTENT ? "true" : "false") + "\">";
        this.indent(level, out);
        out.print(stag);
        if (root.getOwnText() == null) {
            out.println();
            for (Box child : root.getChildren()) {
                this.recursiveDump(child, level + 1, out);
            }
            this.indent(level, out);
        } else {
            out.print(this.HTMLEntities(root.getOwnText()));
        }
        out.println("</box>");
    }

    private void indent(int level, PrintWriter p) {
        Object ind = "";
        for (int i = 0; i < level * 4; ++i) {
            ind = (String)ind + " ";
        }
        p.print((String)ind);
    }

    private String colorString(Color color) {
        if (color == null) {
            return "";
        }
        return String.format("#%02x%02x%02x", color.getRed(), color.getGreen(), color.getBlue());
    }

    private String HTMLEntities(String s) {
        return s.replaceAll(">", "&gt;").replaceAll("<", "&lt;").replaceAll("&", "&amp;");
    }
}

