/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.layout.io;

import cz.vutbr.fit.layout.api.Parameter;
import cz.vutbr.fit.layout.impl.BaseOperator;
import cz.vutbr.fit.layout.impl.ParameterBoolean;
import cz.vutbr.fit.layout.impl.ParameterString;
import cz.vutbr.fit.layout.model.Area;
import cz.vutbr.fit.layout.model.AreaTree;
import cz.vutbr.fit.layout.model.Border;
import cz.vutbr.fit.layout.model.Box;
import cz.vutbr.fit.layout.model.Color;
import cz.vutbr.fit.layout.model.ContentRect;
import cz.vutbr.fit.layout.model.Page;
import cz.vutbr.fit.layout.model.Rectangular;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HTMLOutputOperator
extends BaseOperator {
    protected static final String UNIT = "px";
    protected boolean produceHeader;
    protected boolean boxTreeOnly;
    protected String filename;

    public HTMLOutputOperator() {
        this.produceHeader = true;
        this.boxTreeOnly = false;
        this.filename = "out.html";
    }

    public HTMLOutputOperator(String filename, boolean produceHeader, boolean boxTreeOnly) {
        this.filename = filename;
        this.produceHeader = produceHeader;
        this.boxTreeOnly = boxTreeOnly;
    }

    public String getId() {
        return "FitLayout.Tools.HTMLOutput";
    }

    public String getName() {
        return "HTML serialization of the area tree";
    }

    public String getDescription() {
        return "Serializes the area tree to an HTML file";
    }

    public String getCategory() {
        return "output";
    }

    public List<Parameter> defineParams() {
        ArrayList<Parameter> ret = new ArrayList<Parameter>(3);
        ret.add((Parameter)new ParameterString("filename"));
        ret.add((Parameter)new ParameterBoolean("produceHeader"));
        ret.add((Parameter)new ParameterBoolean("boxTreeOnly"));
        return ret;
    }

    public boolean getProduceHeader() {
        return this.produceHeader;
    }

    public void setProduceHeader(boolean produceHeader) {
        this.produceHeader = produceHeader;
    }

    public boolean getBoxTreeOnly() {
        return this.boxTreeOnly;
    }

    public void setBoxTreeOnly(boolean boxTreeOnly) {
        this.boxTreeOnly = boxTreeOnly;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public void apply(AreaTree atree) {
        this.apply(atree, atree.getRoot());
    }

    public void apply(AreaTree atree, Area root) {
        try {
            Page page = (Page)this.getServiceManager().getArtifactRepository().getArtifact(atree.getParentIri());
            PrintWriter out = new PrintWriter(this.filename);
            if (this.boxTreeOnly) {
                this.dumpTo(page, out);
            } else {
                this.dumpTo(atree, page, out);
            }
            out.close();
        }
        catch (FileNotFoundException e) {
            System.err.println("Couldn't create output HTML file " + this.filename);
        }
    }

    public void dumpTo(AreaTree tree, Page sourcePage, PrintWriter out) {
        if (this.produceHeader) {
            out.println("<!DOCTYPE html>");
            out.println("<html>");
            out.println("<head>");
            if (sourcePage != null) {
                out.println("<title>" + sourcePage.getTitle() + "</title>");
            }
            out.println("<meta charset=\"utf-8\">");
            out.println("<meta name=\"generator\" content=\"FITLayout - area tree dump\">");
            out.println("<style>");
            out.println("span { white-space: nowrap; }");
            out.println("</style>");
            out.println("</head>");
            out.println("<body>");
        }
        this.recursiveDumpArea(tree.getRoot(), 1, out);
        if (this.produceHeader) {
            out.println("</body>");
            out.println("</html>");
        }
    }

    public void dumpTo(Page page, PrintWriter out) {
        if (this.produceHeader) {
            out.println("<!DOCTYPE html>");
            out.println("<html>");
            out.println("<head>");
            out.println("<title>" + page.getTitle() + "</title>");
            out.println("<meta charset=\"utf-8\">");
            out.println("<meta name=\"generator\" content=\"FITLayout - box tree dump\">");
            out.println("<style>");
            out.println("span { white-space: nowrap; }");
            out.println("</style>");
            out.println("</head>");
            out.println("<body>");
        }
        this.recursiveDumpBoxes(page.getRoot(), 1, out);
        if (this.produceHeader) {
            out.println("</body>");
            out.println("</html>");
        }
    }

    private void recursiveDumpArea(Area a, int level, PrintWriter p) {
        String tagName = "div";
        String stag = "<" + tagName + " id=\"a" + a.getId() + "\" style=\"" + this.getAreaStyle(a) + "\">";
        String etag = "</" + tagName + ">";
        if (a.getChildCount() > 0) {
            this.indent(level, p);
            p.println(stag);
            for (int i = 0; i < a.getChildCount(); ++i) {
                this.recursiveDumpArea((Area)a.getChildAt(i), level + 1, p);
            }
            this.indent(level, p);
            p.println(etag);
        } else {
            this.indent(level, p);
            p.println(stag);
            this.dumpAreaBoxes(a, p, level + 1);
            this.indent(level, p);
            p.println(etag);
        }
    }

    private void dumpAreaBoxes(Area a, PrintWriter p, int level) {
        List boxes = a.getBoxes();
        for (Box box : boxes) {
            if (box.getType() == Box.Type.TEXT_CONTENT) {
                this.indent(level, p);
                String stag = "<span id=\"b" + box.getId() + "\" style=\"" + this.getBoxStyle((ContentRect)a, box) + "\">";
                p.print(stag);
                p.print(this.HTMLEntities(box.getText()));
                p.println("</span>");
                continue;
            }
            Style style = this.getBoxStyle((ContentRect)a, box);
            style.put("width", this.getContentWidth(box), UNIT);
            style.put("height", this.getContentHeight(box), UNIT);
            String stag = "<div id=\"b" + box.getId() + "\" style=\"" + style + "\">";
            this.indent(level, p);
            p.println(stag);
            for (int i = 0; i < box.getChildCount(); ++i) {
                this.recursiveDumpBoxes((Box)box.getChildAt(i), level + 1, p);
            }
            this.indent(level, p);
            p.println("</div>");
        }
    }

    private void recursiveDumpBoxes(Box box, int level, PrintWriter p) {
        if (box.getType() == Box.Type.TEXT_CONTENT) {
            this.indent(level, p);
            String stag = "<span id=\"b" + box.getId() + "\" style=\"" + this.getBoxStyle((ContentRect)box.getParent(), box) + "\">";
            p.print(stag);
            p.print(this.HTMLEntities(box.getText()));
            p.println("</span>");
        } else {
            Style style = this.getBoxStyle((ContentRect)box.getParent(), box);
            style.put("width", this.getContentWidth(box), UNIT);
            style.put("height", this.getContentHeight(box), UNIT);
            String stag = "<div id=\"b" + box.getId() + "\" style=\"" + style + "\">";
            this.indent(level, p);
            p.println(stag);
            for (int i = 0; i < box.getChildCount(); ++i) {
                this.recursiveDumpBoxes((Box)box.getChildAt(i), level + 1, p);
            }
            this.indent(level, p);
            p.println("</div>");
        }
    }

    protected String getAreaStyle(Area a) {
        Area parent = (Area)a.getParent();
        int px = 0;
        int py = 0;
        if (parent != null) {
            Border btop;
            px = parent.getX1();
            py = parent.getY1();
            Border bleft = parent.getBorderStyle(Border.Side.LEFT);
            if (bleft != null) {
                px += bleft.getWidth();
            }
            if ((btop = parent.getBorderStyle(Border.Side.TOP)) != null) {
                py += btop.getWidth();
            }
        }
        int bw = 0;
        int bh = 0;
        Style style = new Style();
        style.put("position", "absolute");
        String bgcol = this.colorString(a.getBackgroundColor());
        if (!bgcol.isEmpty()) {
            style.put("background", bgcol);
        }
        for (Border.Side side : Border.Side.values()) {
            Border bstyle = a.getBorderStyle(side);
            String brd = this.getBorderStyle(bstyle);
            if (brd.isEmpty()) continue;
            style.put("border-" + side.toString(), brd);
            if (side == Border.Side.LEFT || side == Border.Side.RIGHT) {
                bw += bstyle.getWidth();
                continue;
            }
            if (side != Border.Side.TOP && side != Border.Side.BOTTOM) continue;
            bh += bstyle.getWidth();
        }
        style.put("left", a.getX1() - px, UNIT);
        style.put("top", a.getY1() - py, UNIT);
        style.put("width", a.getWidth() - bw, UNIT);
        style.put("height", a.getHeight() - bh, UNIT);
        return style.toString();
    }

    protected Style getBoxStyle(ContentRect parent, Box box) {
        int px = 0;
        int py = 0;
        if (parent != null) {
            px = parent.getX1() + parent.getBorderStyle(Border.Side.LEFT).getWidth();
            py = parent.getY1() + parent.getBorderStyle(Border.Side.TOP).getWidth();
        }
        return this.getBoxStyle(box, px, py);
    }

    protected Style getBoxStyle(Box box, int px, int py) {
        Rectangular pos = box.getVisualBounds();
        Style style = new Style();
        style.put("position", "absolute");
        style.put("top", pos.getY1() - py, UNIT);
        style.put("left", pos.getX1() - px, UNIT);
        style.put("color", this.colorString(box.getColor()));
        String bgcol = this.colorString(box.getBackgroundColor());
        if (!bgcol.isEmpty()) {
            style.put("background", bgcol);
        }
        style.put("font-family", box.getFontFamily());
        style.put("font-size", box.getTextStyle().getFontSize(), UNIT);
        style.put("font-weight", box.getTextStyle().getFontWeight() < 0.5f ? "normal" : "bold");
        style.put("font-style", box.getTextStyle().getFontStyle() < 0.5f ? "normal" : "italic");
        Object deco = "";
        if (box.getTextStyle().getUnderline() >= 0.5f) {
            deco = (String)deco + "underline";
        }
        if (box.getTextStyle().getLineThrough() >= 0.5f) {
            deco = (String)deco + " line-through";
        }
        if (((String)deco).isEmpty()) {
            deco = "none";
        }
        style.put("text-decoration", deco);
        for (Border.Side side : Border.Side.values()) {
            String brd = this.getBorderStyle(box.getBorderStyle(side));
            if (brd.isEmpty()) continue;
            style.put("border-" + side.toString(), brd);
        }
        return style;
    }

    private String getBorderStyle(Border border) {
        if (border != null && border.getStyle() != Border.Style.NONE && border.getWidth() > 0) {
            StringBuilder ret = new StringBuilder();
            ret.append(border.getWidth()).append(UNIT);
            ret.append(' ').append(border.getStyle().toString().toLowerCase());
            ret.append(' ').append(this.colorString(border.getColor()));
            return ret.toString();
        }
        return "";
    }

    private int getContentWidth(Box box) {
        return box.getWidth() - box.getLeftBorder() - box.getRightBorder();
    }

    private int getContentHeight(Box box) {
        return box.getHeight() - box.getTopBorder() - box.getBottomBorder();
    }

    private void indent(int level, PrintWriter p) {
        Object ind = "";
        for (int i = 0; i < level * 4; ++i) {
            ind = (String)ind + " ";
        }
        p.print((String)ind);
    }

    private String colorString(Color color) {
        if (color == null) {
            return "";
        }
        return String.format("#%02x%02x%02x", color.getRed(), color.getGreen(), color.getBlue());
    }

    public String colorString(String spec) {
        if (spec.startsWith("rgb(")) {
            String s = spec.substring(4, spec.length() - 1);
            String[] lst = s.split(",");
            try {
                int r = Integer.parseInt(lst[0].trim());
                int g = Integer.parseInt(lst[1].trim());
                int b = Integer.parseInt(lst[2].trim());
                return String.format("#%02x%02x%02x", r, g, b);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return spec;
    }

    private String HTMLEntities(String s) {
        return s.replaceAll(">", "&gt;").replaceAll("<", "&lt;").replaceAll("&", "&amp;");
    }

    protected class Style
    extends HashMap<String, String> {
        private static final long serialVersionUID = 1L;

        protected Style() {
        }

        public void put(String key, int value, String unit) {
            this.put(key, value + unit);
        }

        public void put(String key, float value, String unit) {
            this.put(key, value + unit);
        }

        @Override
        public String toString() {
            StringBuilder ret = new StringBuilder();
            for (Map.Entry entry : this.entrySet()) {
                ret.append((String)entry.getKey()).append(':').append((String)entry.getValue()).append(';');
            }
            return ret.toString();
        }
    }
}

