/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.layout.io;

import cz.vutbr.fit.layout.api.OutputDisplay;
import cz.vutbr.fit.layout.io.HTMLOutputOperator;
import cz.vutbr.fit.layout.io.ImageOutputDisplay;
import cz.vutbr.fit.layout.io.XMLBoxOutput;
import cz.vutbr.fit.layout.io.XMLOutputOperator;
import cz.vutbr.fit.layout.model.Area;
import cz.vutbr.fit.layout.model.AreaTree;
import cz.vutbr.fit.layout.model.Page;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;

public class ArtifactStreamOutput {
    public static void outputXML(Page page, OutputStream os) throws IOException {
        PrintWriter out = new PrintWriter(os);
        XMLBoxOutput xml = new XMLBoxOutput(true);
        xml.dumpTo(page, out);
        out.close();
    }

    public static void outputHTML(Page page, OutputStream os) throws IOException {
        PrintWriter out = new PrintWriter(os);
        HTMLOutputOperator html = new HTMLOutputOperator();
        html.dumpTo(page, out);
        out.close();
    }

    public static void outputPNG(Page page, OutputStream os) throws IOException {
        ImageOutputDisplay disp = new ImageOutputDisplay(page.getWidth(), page.getHeight());
        if (page.getPngImage() != null) {
            disp.drawPage(page, true);
        } else {
            disp.drawPage(page, false);
        }
        disp.saveTo(os);
    }

    public static void outputPNGi(Page page, OutputStream os) throws IOException {
        ImageOutputDisplay disp = new ImageOutputDisplay(page.getWidth(), page.getHeight());
        disp.drawPage(page, false);
        disp.saveTo(os);
    }

    public static void outputXML(AreaTree atree, OutputStream os) throws IOException {
        XMLOutputOperator out = new XMLOutputOperator(null, true);
        PrintWriter writer = new PrintWriter(os);
        out.dumpTo(atree, writer);
        writer.close();
    }

    public static void outputHTML(AreaTree atree, Page page, OutputStream os) throws IOException {
        if (page == null) {
            throw new IllegalArgumentException("HTML export requires a page available (use RENDER or LOAD).");
        }
        PrintWriter out = new PrintWriter(os);
        HTMLOutputOperator html = new HTMLOutputOperator();
        html.dumpTo(atree, page, out);
        out.close();
    }

    public static void outputPNG(AreaTree atree, Page page, OutputStream os) throws IOException {
        ImageOutputDisplay disp = new ImageOutputDisplay(page.getWidth(), page.getHeight());
        if (page.getPngImage() != null) {
            disp.drawPage(page, true);
        } else {
            disp.drawPage(page, false);
        }
        ArtifactStreamOutput.showAreas(disp, atree.getRoot(), null);
        disp.saveTo(os);
    }

    public static void outputPNGi(AreaTree atree, Page page, OutputStream os) throws IOException {
        ImageOutputDisplay disp = new ImageOutputDisplay(page.getWidth(), page.getHeight());
        disp.drawPage(page, false);
        ArtifactStreamOutput.showAreas(disp, atree.getRoot(), null);
        disp.saveTo(os);
    }

    private static void showAreas(OutputDisplay disp, Area root, String nameSubstring) {
        if (nameSubstring == null || root.toString().contains(nameSubstring)) {
            disp.drawExtent(root);
        }
        for (int i = 0; i < root.getChildCount(); ++i) {
            ArtifactStreamOutput.showAreas(disp, (Area)root.getChildAt(i), nameSubstring);
        }
    }
}

