/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.layout.io;

import cz.vutbr.fit.layout.api.Parameter;
import cz.vutbr.fit.layout.impl.BaseOperator;
import cz.vutbr.fit.layout.impl.ParameterString;
import cz.vutbr.fit.layout.model.Area;
import cz.vutbr.fit.layout.model.AreaTree;
import cz.vutbr.fit.layout.model.Box;
import cz.vutbr.fit.layout.model.Color;
import cz.vutbr.fit.layout.model.Page;
import cz.vutbr.fit.layout.model.Rectangular;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.unbescape.json.JsonEscape;

public class JSONOutputOperator
extends BaseOperator {
    protected String filename;
    private int idCount = 0;
    private int labelCount = 0;
    private int countPages = 0;
    private int countPagesSucces = 0;
    private int train = 0;
    boolean[] labels = new boolean[5];

    public JSONOutputOperator() {
        this.filename = "out.json";
    }

    public JSONOutputOperator(String filename) {
        this.filename = filename;
    }

    public String getId() {
        return "FitLayout.Tools.JSONOutput";
    }

    public String getName() {
        return "JSON serialization of the area tree";
    }

    public String getDescription() {
        return "Serializes the area tree to a JSON file";
    }

    public String getCategory() {
        return "output";
    }

    public List<Parameter> defineParams() {
        ArrayList<Parameter> ret = new ArrayList<Parameter>(2);
        ret.add((Parameter)new ParameterString("filename"));
        return ret;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public void apply(AreaTree atree) {
        this.apply(atree, atree.getRoot());
    }

    public void apply(AreaTree atree, Area root) {
        try {
            PrintWriter out = new PrintWriter(this.filename);
            this.dumpTo(atree, out);
            out.close();
        }
        catch (FileNotFoundException e) {
            System.err.println("Couldn't create output file " + this.filename);
        }
    }

    public void dumpTo(AreaTree atree, PrintWriter writer) {
        this.idCount = 0;
        this.labelCount = 0;
        ++this.countPages;
        Arrays.fill(this.labels, Boolean.FALSE);
        this.recursivelyDumpTo(atree.getRoot(), 1, writer);
    }

    public void dumpTo(Page page, PrintWriter writer) {
        this.idCount = 0;
        this.labelCount = 0;
        ++this.countPages;
        Arrays.fill(this.labels, Boolean.FALSE);
        this.dumpBoxes(List.of(page.getRoot()), 1, writer, true);
    }

    private void recursivelyDumpTo(Area area, int level, PrintWriter writer) {
        ++this.idCount;
        String start = this.tab(level - 1) + "{\n" + this.tab(level) + "\"id\": " + this.idCount + ",\n" + this.tab(level) + "\"level\": " + level + ",\n" + this.tab(level) + "\"x1\": " + area.getX1() + ",\n" + this.tab(level) + "\"y1\": " + area.getY1() + ",\n" + this.tab(level) + "\"x2\": " + area.getX2() + ",\n" + this.tab(level) + "\"y2\": " + area.getY2() + ",\n" + this.tab(level) + "\"height\": " + area.getHeight() + ",\n" + this.tab(level) + "\"width\": " + area.getWidth() + ",\n" + this.tab(level) + "\"background\": \"" + this.getColor(area.getEffectiveBackgroundColor()) + "\",\n" + this.tab(level) + "\"fontsize\": " + area.getTextStyle().getFontSize() + ",\n" + this.tab(level) + "\"fontweight\": " + area.getTextStyle().getFontWeight() + ",\n" + this.tab(level) + "\"exp_separated\": " + (area.isExplicitlySeparated() ? "true" : "false") + ",\n" + this.tab(level) + "\"hor_separator\": " + (area.isHorizontalSeparator() ? "true" : "false") + ",\n" + this.tab(level) + "\"ver_separator\": " + (area.isVerticalSeparator() ? "true" : "false") + ",\n" + this.tab(level) + "\"fontstyle\": " + area.getTextStyle().getFontStyle();
        String end = "\n" + this.tab(level - 1) + "}";
        if (area.getChildCount() == 0) {
            start = start + ",\n" + this.tab(level) + "\"boxes\": [\n";
            end = this.tab(level) + "]" + end;
            writer.print(start);
            this.dumpBoxes(area.getBoxes(), level + 1, writer, false);
            writer.print(end);
        } else {
            start = start + ",\n" + this.tab(level) + "\"areas\": [\n";
            end = "]" + end;
            writer.print(start);
            for (int i = 0; i < area.getChildCount(); ++i) {
                this.recursivelyDumpTo((Area)area.getChildAt(i), level + 1, writer);
                if (i >= area.getChildCount() - 1) continue;
                writer.print(",\n");
            }
            writer.print(end);
        }
    }

    private void dumpBoxes(List<Box> boxes, int level, PrintWriter writer, boolean recursive) {
        Iterator<Box> iBoxes = boxes.iterator();
        while (iBoxes.hasNext()) {
            Box box = iBoxes.next();
            int label = 0;
            if (this.train == 1) {
                label = this.getLabel(box);
                if (label != 0) {
                    this.labels[label - 1] = true;
                }
                if (label != 0) {
                    ++this.labelCount;
                }
            }
            Rectangular pos = box.getVisualBounds();
            String sBox = this.tab(level) + "{\n" + this.tab(level + 1) + "\"x1\": " + pos.getX1() + ",\n" + this.tab(level + 1) + "\"y1\": " + pos.getY1() + ",\n" + this.tab(level + 1) + "\"x2\": " + pos.getX2() + ",\n" + this.tab(level + 1) + "\"y2\": " + pos.getY2() + ",\n" + this.tab(level + 1) + "\"height\": " + pos.getHeight() + ",\n" + this.tab(level + 1) + "\"width\": " + pos.getWidth() + ",\n" + this.tab(level + 1) + "\"color\": \"" + this.getColor(box.getColor()) + "\",\n" + this.tab(level + 1) + "\"fontfamily\": \"" + box.getFontFamily() + "\",\n" + this.tab(level + 1) + "\"fontsize\": " + box.getTextStyle().getFontSize() + ",\n" + this.tab(level + 1) + "\"fontweight\": " + box.getTextStyle().getFontWeight() + ",\n" + this.tab(level + 1) + "\"fontstyle\": " + box.getTextStyle().getFontStyle() + ",\n" + this.tab(level + 1) + "\"underline\": " + box.getTextStyle().getUnderline() + ",\n" + this.tab(level + 1) + "\"linethrough\": " + box.getTextStyle().getLineThrough() + ",\n" + this.tab(level + 1) + "\"type\": " + box.getType().ordinal() + ",\n" + this.tab(level + 1) + "\"displayType\": " + box.getDisplayType().ordinal() + ",\n" + this.tab(level + 1) + "\"tag\": \"" + box.getTagName() + "\",\n" + this.tab(level + 1) + "\"visible\": \"" + (box.isVisible() ? "true" : "false") + "\",\n" + this.tab(level + 1) + "\"separated\": \"" + (box.isVisuallySeparated() ? "true" : "false") + "\",\n";
            if (recursive) {
                if (box.getOwnText() != null) {
                    sBox = sBox + this.tab(level + 1) + "\"text\": \"" + JsonEscape.escapeJson((String)box.getOwnText()) + "\"";
                }
            } else {
                sBox = sBox + this.tab(level + 1) + "\"text\": \"" + JsonEscape.escapeJson((String)box.getText()) + "\"";
            }
            if (this.train == 1) {
                sBox = sBox + ",\n" + this.tab(level + 1) + "\"label\": " + label;
            }
            writer.print(sBox);
            String eBox = this.tab(level) + "\n" + this.tab(level) + "}";
            if (recursive && box.getChildCount() > 0) {
                writer.print(this.tab(level + 1) + "\"boxes\": [\n");
                this.dumpBoxes(box.getChildren(), level + 2, writer, recursive);
                writer.print(this.tab(level + 1) + "]\n");
            }
            if (iBoxes.hasNext()) {
                eBox = eBox + ",";
            }
            eBox = eBox + "\n";
            writer.print(eBox);
        }
    }

    private int getLabel(Box box) {
        for (Box tempBox = box; tempBox != null; tempBox = tempBox.getIntrinsicParent()) {
            String label = tempBox.getAttribute("klarna-ai-label");
            if (label == null) continue;
            switch (label) {
                case "Name": {
                    return 1;
                }
                case "Price": {
                    return 2;
                }
                case "Main picture": {
                    return 3;
                }
                case "Add to cart": {
                    return 4;
                }
                case "Cart": {
                    return 5;
                }
            }
            return 0;
        }
        return 0;
    }

    private String getColor(Color color) {
        return color == null ? "" : String.format("#%02x%02x%02x", color.getRed(), color.getGreen(), color.getBlue());
    }

    private String tab(int count) {
        return "\t".repeat(Math.max(0, count));
    }

    public double getSuccessRate() {
        if (this.train == 1) {
            return (double)this.countPagesSucces / (double)this.countPages;
        }
        return 0.0;
    }

    public int getLabelCount() {
        return this.labelCount;
    }
}

