/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.layout.map;

import cz.vutbr.fit.layout.map.Example;
import cz.vutbr.fit.layout.map.MetadataExampleGenerator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;

public class ExampleMatcher {
    private MetadataExampleGenerator exampleGenerator;
    private Map<String, List<Example>> examples;
    private Map<Float, List<Example>> floatExamples;

    public ExampleMatcher(MetadataExampleGenerator exampleGenerator) {
        this.exampleGenerator = exampleGenerator;
        this.examples = exampleGenerator.getStringExamples();
        this.floatExamples = exampleGenerator.getFloatExamples();
    }

    public boolean match(String rawText, Consumer<List<Example>> op) {
        HashSet<Example> usedExamples = new HashSet<Example>();
        boolean ret = this.tryStringExamples(rawText, usedExamples, op);
        if (!ret && !this.floatExamples.isEmpty()) {
            ret |= this.tryFloatExamples(rawText, usedExamples, op);
        }
        return ret;
    }

    private boolean tryStringExamples(String rawText, Set<Example> usedExamples, Consumer<List<Example>> op) {
        String text = this.exampleGenerator.filterKey(rawText);
        List<Example> mappedExamples = this.examples.get(text);
        if (mappedExamples != null && !mappedExamples.isEmpty()) {
            op.accept(mappedExamples);
            usedExamples.addAll(mappedExamples);
            return true;
        }
        return false;
    }

    private boolean tryFloatExamples(String rawText, Set<Example> usedExamples, Consumer<List<Example>> op) {
        String text = rawText.replaceAll("[^a-zA-Z0-9\\,\\.]", "");
        if (text.contains(",") && !text.contains(".")) {
            text = text.replace(',', '.');
        }
        try {
            float val = Float.parseFloat(text);
            List<Example> mappedExamples = this.floatExamples.get(Float.valueOf(val));
            if (mappedExamples != null) {
                mappedExamples.removeAll(usedExamples);
                if (!mappedExamples.isEmpty()) {
                    op.accept(mappedExamples);
                    return true;
                }
                return false;
            }
            return false;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }
}

