/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.layout.map.chunks;

import cz.vutbr.fit.layout.impl.DefaultTextChunk;
import cz.vutbr.fit.layout.map.Example;
import cz.vutbr.fit.layout.map.ExampleMatcher;
import cz.vutbr.fit.layout.map.MetaRefTag;
import cz.vutbr.fit.layout.map.MetadataExampleGenerator;
import cz.vutbr.fit.layout.map.TextUtils;
import cz.vutbr.fit.layout.model.Area;
import cz.vutbr.fit.layout.model.Rectangular;
import cz.vutbr.fit.layout.model.Tag;
import cz.vutbr.fit.layout.model.TextChunk;
import cz.vutbr.fit.layout.text.chunks.ChunksSource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetadataChunksExtractor
extends ChunksSource {
    private static Logger log = LoggerFactory.getLogger(MetadataChunksExtractor.class);
    private int idCounter = 1;
    private Map<Example, MetaRefTag> assignedTags;
    private ExampleMatcher matcher;

    public MetadataChunksExtractor(Area root, MetadataExampleGenerator exampleGenerator, Collection<MetaRefTag> tags) {
        super(root);
        this.matcher = new ExampleMatcher(exampleGenerator);
        this.assignedTags = new HashMap<Example, MetaRefTag>();
        for (MetaRefTag tag : tags) {
            this.assignedTags.put(tag.getExample(), tag);
        }
    }

    public Collection<MetaRefTag> getAssignedTags() {
        return this.assignedTags.values();
    }

    public List<TextChunk> getTextChunks() {
        ArrayList<TextChunk> dest = new ArrayList<TextChunk>(100);
        this.createChunksForSubtree(this.getRoot(), dest);
        return dest;
    }

    private boolean createChunksForSubtree(Area root, List<TextChunk> dest) {
        boolean childrenMatched = false;
        for (Area child : root.getChildren()) {
            childrenMatched |= this.createChunksForSubtree(child, dest);
        }
        if (childrenMatched) {
            return true;
        }
        return this.matcher.match(TextUtils.getText(root), mappedExamples -> this.createChunksForArea(root, (List<Example>)mappedExamples, dest));
    }

    private void createChunksForArea(Area area, List<Example> mappedExamples, List<TextChunk> dest) {
        for (Example ex : mappedExamples) {
            dest.add(this.createChunkForExample(area, ex));
        }
    }

    private TextChunk createChunkForExample(Area area, Example example) {
        Rectangular rectangular = new Rectangular(area.getBounds());
        DefaultTextChunk chunk = new DefaultTextChunk();
        chunk.setId(this.idCounter++);
        chunk.setBounds(rectangular);
        chunk.setSourceArea(area);
        chunk.setText(example.getText());
        MetaRefTag tag = this.assignedTags.get(example);
        if (tag == null) {
            log.warn("No tag found for example {}", (Object)example);
        } else {
            chunk.addTag((Tag)tag, 0.95f);
        }
        chunk.setName("<chunk:" + example.getPredicate().getLocalName() + "> " + example.getText());
        return chunk;
    }
}

