/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.layout.map.chunks;

import cz.vutbr.fit.layout.api.Parameter;
import cz.vutbr.fit.layout.api.ServiceException;
import cz.vutbr.fit.layout.impl.BaseArtifactService;
import cz.vutbr.fit.layout.map.MetaRefTag;
import cz.vutbr.fit.layout.map.MetadataExampleGenerator;
import cz.vutbr.fit.layout.map.MetadataTagManager;
import cz.vutbr.fit.layout.map.chunks.MetadataChunksExtractor;
import cz.vutbr.fit.layout.model.AreaTree;
import cz.vutbr.fit.layout.model.Artifact;
import cz.vutbr.fit.layout.model.ChunkSet;
import cz.vutbr.fit.layout.model.TextChunk;
import cz.vutbr.fit.layout.ontology.MAPPING;
import cz.vutbr.fit.layout.ontology.SEGM;
import cz.vutbr.fit.layout.rdf.RDFArtifactRepository;
import cz.vutbr.fit.layout.rdf.model.RDFChunkSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.vocabulary.RDF;

public class MetadataTextChunksProvider
extends BaseArtifactService {
    public String getId() {
        return "FitLayout.MetadataTextChunks";
    }

    public String getName() {
        return "Metadata-based chunks extractor";
    }

    public String getDescription() {
        return "Extracts text chunks mentioned in page metadata.";
    }

    public List<Parameter> defineParams() {
        ArrayList<Parameter> ret = new ArrayList<Parameter>(1);
        return ret;
    }

    public IRI getConsumes() {
        return SEGM.AreaTree;
    }

    public IRI getProduces() {
        return SEGM.ChunkSet;
    }

    public Artifact process(Artifact input) throws ServiceException {
        if (input != null && input instanceof AreaTree) {
            return this.extractChunks((AreaTree)input);
        }
        throw new ServiceException("Source artifact not specified or not an area tree");
    }

    private ChunkSet extractChunks(AreaTree atree) {
        if (!(this.getServiceManager().getArtifactRepository() instanceof RDFArtifactRepository)) {
            throw new ServiceException(this.getId() + " can be used with RDFArtifactRepository only");
        }
        RDFArtifactRepository repo = (RDFArtifactRepository)this.getServiceManager().getArtifactRepository();
        IRI metadataContextIri = repo.getMetadataIRI(atree.getPageIri());
        MetadataExampleGenerator gen = new MetadataExampleGenerator(repo, metadataContextIri, MetadataExampleGenerator::normalizeText);
        MetadataTagManager tagMgr = new MetadataTagManager(repo, metadataContextIri);
        Collection<MetaRefTag> tags = tagMgr.checkForTags(gen.getExamples());
        MetadataChunksExtractor csrc = new MetadataChunksExtractor(atree.getRoot(), gen, tags);
        List<TextChunk> chunks = csrc.getTextChunks();
        RDFChunkSet ret = new RDFChunkSet(atree.getIri(), new HashSet<TextChunk>(chunks));
        ret.setPageIri(atree.getPageIri());
        ret.setLabel(this.getId());
        ret.setCreator(this.getId());
        ret.setCreatorParams(this.getParamString());
        ValueFactory vf = repo.getStorage().getValueFactory();
        HashSet<Statement> stmts = new HashSet<Statement>();
        for (MetaRefTag tag : csrc.getAssignedTags()) {
            stmts.add(vf.createStatement((Resource)tag.getIri(), RDF.TYPE, (Value)SEGM.Tag));
            stmts.add(vf.createStatement((Resource)tag.getIri(), SEGM.type, (Value)vf.createLiteral(tag.getType())));
            stmts.add(vf.createStatement((Resource)tag.getIri(), SEGM.name, (Value)vf.createLiteral(tag.getName())));
            stmts.add(vf.createStatement((Resource)tag.getIri(), MAPPING.describesInstance, (Value)tag.getExample().getSubject()));
            stmts.add(vf.createStatement((Resource)tag.getIri(), MAPPING.isValueOf, (Value)tag.getExample().getPredicate()));
        }
        ret.setAdditionalStatements(stmts);
        return ret;
    }
}

