/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.layout.map.op;

import cz.vutbr.fit.layout.api.Parameter;
import cz.vutbr.fit.layout.impl.BaseOperator;
import cz.vutbr.fit.layout.map.Example;
import cz.vutbr.fit.layout.map.ExampleMatcher;
import cz.vutbr.fit.layout.map.MetaRefTag;
import cz.vutbr.fit.layout.map.MetadataExampleGenerator;
import cz.vutbr.fit.layout.map.MetadataTagManager;
import cz.vutbr.fit.layout.map.TextUtils;
import cz.vutbr.fit.layout.model.Area;
import cz.vutbr.fit.layout.model.AreaTree;
import cz.vutbr.fit.layout.model.Tag;
import cz.vutbr.fit.layout.rdf.RDFArtifactRepository;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.rdf4j.model.IRI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TagByExamplesOperator
extends BaseOperator {
    private static Logger log = LoggerFactory.getLogger(TagByExamplesOperator.class);

    public String getId() {
        return "FitLayout.Tag.Examples";
    }

    public String getName() {
        return "Tag by examples";
    }

    public String getDescription() {
        return "Tags the areas that correspond to the occurrences of examples obtained from page metadata by the corresponding tags";
    }

    public String getCategory() {
        return "Classification";
    }

    public List<Parameter> defineParams() {
        ArrayList<Parameter> ret = new ArrayList<Parameter>(1);
        return ret;
    }

    public void apply(AreaTree atree) {
        this.apply(atree, atree.getRoot());
    }

    public void apply(AreaTree atree, Area root) {
        if (!(this.getServiceManager().getArtifactRepository() instanceof RDFArtifactRepository)) {
            throw new RuntimeException("This operator may be used with RDF artifact repository only");
        }
        RDFArtifactRepository repo = (RDFArtifactRepository)this.getServiceManager().getArtifactRepository();
        IRI metadataContextIri = repo.getMetadataIRI(atree.getPageIri());
        MetadataExampleGenerator gen = new MetadataExampleGenerator(repo, metadataContextIri, MetadataExampleGenerator::normalizeText);
        MetadataTagManager tagMgr = new MetadataTagManager(repo, metadataContextIri);
        Collection<MetaRefTag> tags = tagMgr.checkForTags(gen.getExamples());
        HashMap<Example, MetaRefTag> assignedTags = new HashMap<Example, MetaRefTag>();
        for (MetaRefTag tag : tags) {
            assignedTags.put(tag.getExample(), tag);
        }
        ExampleMatcher matcher = new ExampleMatcher(gen);
        this.recursiveMapOcurrences(root, matcher, assignedTags);
    }

    private boolean recursiveMapOcurrences(Area root, ExampleMatcher matcher, Map<Example, MetaRefTag> assignedTags) {
        boolean childrenMatched = false;
        for (Area child : root.getChildren()) {
            childrenMatched |= this.recursiveMapOcurrences(child, matcher, assignedTags);
        }
        if (childrenMatched) {
            return true;
        }
        return matcher.match(TextUtils.getText(root), mappedExamples -> this.assignTagsForExamples(root, (List<Example>)mappedExamples, assignedTags));
    }

    private void assignTagsForExamples(Area root, List<Example> examples, Map<Example, MetaRefTag> assignedTags) {
        for (Example example : examples) {
            MetaRefTag tag = assignedTags.get(example);
            if (tag == null) {
                log.warn("No tag found for example {}", (Object)example);
                continue;
            }
            root.addTag((Tag)tag, 0.95f);
        }
    }
}

