/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.layout.map;

import cz.vutbr.fit.layout.map.Example;
import cz.vutbr.fit.layout.map.MetadataExampleGenerator;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.chrono.ChronoLocalDate;
import java.time.temporal.TemporalAccessor;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.natty.DateGroup;
import org.natty.Parser;

public class ExampleMatcher {
    private MetadataExampleGenerator exampleGenerator;
    private Map<String, List<Example>> examples;
    private Map<Float, List<Example>> floatExamples;
    private Map<TemporalAccessor, List<Example>> dateExamples;
    private Map<TemporalAccessor, List<Example>> dateTimeMinutesExamples;
    private Map<TemporalAccessor, List<Example>> dateTimeSecondsExamples;

    public ExampleMatcher(MetadataExampleGenerator exampleGenerator) {
        this.exampleGenerator = exampleGenerator;
        this.examples = exampleGenerator.getStringExamples();
        this.floatExamples = exampleGenerator.getFloatExamples();
        this.dateExamples = exampleGenerator.getTemporalExamples(MetadataExampleGenerator.TempPrecision.DATES);
        this.dateTimeMinutesExamples = exampleGenerator.getTemporalExamples(MetadataExampleGenerator.TempPrecision.MINUTES);
        this.dateTimeSecondsExamples = exampleGenerator.getTemporalExamples(MetadataExampleGenerator.TempPrecision.SECONDS);
        System.out.println(this.dateExamples);
    }

    public boolean match(String rawText, Consumer<List<Example>> op) {
        HashSet<Example> usedExamples = new HashSet<Example>();
        boolean ret = this.tryStringExamples(rawText, usedExamples, op);
        if (!ret && !this.floatExamples.isEmpty()) {
            ret |= this.tryFloatExamples(rawText, usedExamples, op);
        }
        if (!ret && !this.dateExamples.isEmpty()) {
            ret |= this.tryDateExamples(rawText, usedExamples, op);
        }
        return ret;
    }

    private boolean tryStringExamples(String rawText, Set<Example> usedExamples, Consumer<List<Example>> op) {
        String text = this.exampleGenerator.filterKey(rawText);
        List<Example> mappedExamples = this.examples.get(text);
        if (mappedExamples != null && !mappedExamples.isEmpty()) {
            op.accept(mappedExamples);
            usedExamples.addAll(mappedExamples);
            return true;
        }
        return false;
    }

    private boolean tryFloatExamples(String rawText, Set<Example> usedExamples, Consumer<List<Example>> op) {
        String text = rawText.replaceAll("[^a-zA-Z0-9\\,\\.]", "");
        if (text.contains(",") && !text.contains(".")) {
            text = text.replace(',', '.');
        }
        try {
            float val = Float.parseFloat(text);
            List<Example> mappedExamples = this.floatExamples.get(Float.valueOf(val));
            if (mappedExamples != null) {
                mappedExamples.removeAll(usedExamples);
                if (!mappedExamples.isEmpty()) {
                    op.accept(mappedExamples);
                    return true;
                }
                return false;
            }
            return false;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private boolean tryDateExamples(String rawText, Set<Example> usedExamples, Consumer<List<Example>> op) {
        String text = rawText;
        if (text.contains("28 Nov")) {
            System.out.println("jo!");
        }
        try {
            DateGroup group;
            List dates;
            Comparable<ChronoLocalDate> ta = null;
            List<Example> mappedExamples = null;
            Parser parser = new Parser();
            List groups = parser.parse(text);
            if (!groups.isEmpty() && !(dates = (group = (DateGroup)groups.get(0)).getDates()).isEmpty()) {
                Date date = (Date)dates.get(0);
                Instant instant = date.toInstant();
                if (group.isTimeInferred()) {
                    ta = LocalDate.ofInstant(instant, MetadataExampleGenerator.TIME_ZONE);
                    mappedExamples = this.dateExamples.get(ta);
                } else {
                    ta = LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault());
                    int sec = instant.atZone(MetadataExampleGenerator.TIME_ZONE).getSecond();
                    mappedExamples = sec == 0 ? this.dateTimeMinutesExamples.get(ta) : this.dateTimeSecondsExamples.get(ta);
                }
            }
            if (mappedExamples != null) {
                mappedExamples.removeAll(usedExamples);
                if (!mappedExamples.isEmpty()) {
                    op.accept(mappedExamples);
                    return true;
                }
                return false;
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }
}

