/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.layout.map;

import cz.vutbr.fit.layout.map.Example;
import cz.vutbr.fit.layout.rdf.RDFArtifactRepository;
import cz.vutbr.fit.layout.rdf.StorageException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.chrono.ChronoLocalDate;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.query.Binding;
import org.eclipse.rdf4j.query.BindingSet;
import org.unbescape.html.HtmlEscape;

public class MetadataExampleGenerator {
    public static final ZoneId TIME_ZONE = ZoneId.systemDefault();
    private RDFArtifactRepository repo;
    private IRI contextIri;
    private Function<String, String> stringFilter;
    private List<Example> examples;

    public MetadataExampleGenerator(RDFArtifactRepository repo, IRI metadataContextIri) {
        this.repo = repo;
        this.contextIri = metadataContextIri;
        this.stringFilter = MetadataExampleGenerator::useExact;
    }

    public MetadataExampleGenerator(RDFArtifactRepository repo, IRI metadataContextIri, Function<String, String> stringFilter) {
        this.repo = repo;
        this.contextIri = metadataContextIri;
        this.stringFilter = stringFilter;
    }

    public List<Example> getExamples() {
        if (this.examples == null) {
            this.examples = this.readExamples();
        }
        return this.examples;
    }

    protected List<Example> readExamples() {
        try {
            String query = "SELECT ?s ?p ?text WHERE { GRAPH <" + this.contextIri + "> {  ?s ?p ?text .   FILTER (isLiteral(?text)) }}";
            List data = this.repo.getStorage().executeSafeTupleQuery(query);
            ArrayList<Example> ret = new ArrayList<Example>(data.size());
            for (BindingSet binding : data) {
                Binding bS = binding.getBinding("s");
                Binding bP = binding.getBinding("p");
                Binding bText = binding.getBinding("text");
                if (bS == null || bP == null || bText == null || !(bS.getValue() instanceof Resource) || !(bP.getValue() instanceof IRI)) continue;
                Example e = new Example((Resource)bS.getValue(), (IRI)bP.getValue(), bText.getValue().stringValue());
                ret.add(e);
            }
            return ret;
        }
        catch (Exception e) {
            throw new StorageException((Throwable)e);
        }
    }

    public Map<String, List<Example>> getStringExamples() {
        List<Example> allExamples = this.getExamples();
        HashMap<String, List<Example>> ret = new HashMap<String, List<Example>>();
        for (Example ex : allExamples) {
            String text = this.stringFilter.apply(ex.getText());
            if (text.isBlank()) continue;
            ArrayList<Example> list = (ArrayList<Example>)ret.get(text);
            if (list == null) {
                list = new ArrayList<Example>(1);
                ret.put(text, list);
            }
            list.add(ex);
        }
        return ret;
    }

    public Map<Float, List<Example>> getFloatExamples() {
        List<Example> allExamples = this.getExamples();
        HashMap<Float, List<Example>> ret = new HashMap<Float, List<Example>>();
        for (Example ex : allExamples) {
            Float key = this.getFloatValue(ex.getText());
            if (key == null) continue;
            ArrayList<Example> list = (ArrayList<Example>)ret.get(key);
            if (list == null) {
                list = new ArrayList<Example>(1);
                ret.put(key, list);
            }
            list.add(ex);
        }
        return ret;
    }

    public Map<TemporalAccessor, List<Example>> getTemporalExamples(TempPrecision precision) {
        List<Example> allExamples = this.getExamples();
        HashMap<TemporalAccessor, List<Example>> ret = new HashMap<TemporalAccessor, List<Example>>();
        for (Example ex : allExamples) {
            TemporalAccessor key = this.getTemporalValue(ex.getText(), precision);
            if (key == null) continue;
            ArrayList<Example> list = (ArrayList<Example>)ret.get(key);
            if (list == null) {
                list = new ArrayList<Example>(1);
                ret.put(key, list);
            }
            list.add(ex);
        }
        return ret;
    }

    public String filterKey(String src) {
        return this.stringFilter.apply(src);
    }

    public Float getFloatValue(String src) {
        if (src != null && !src.isBlank()) {
            try {
                return Float.valueOf(Float.parseFloat(src));
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return null;
    }

    public TemporalAccessor getTemporalValue(String src, TempPrecision precision) {
        if (src != null && !src.isBlank()) {
            TemporalAccessor ta2;
            Comparable<ChronoLocalDate> ret = null;
            try {
                ta2 = DateTimeFormatter.ISO_DATE_TIME.parse(src);
                switch (precision) {
                    case DATES: {
                        ret = LocalDate.ofInstant(Instant.from(ta2), TIME_ZONE);
                        break;
                    }
                    case MINUTES: {
                        ret = LocalDateTime.ofInstant(Instant.from(ta2).truncatedTo(ChronoUnit.MINUTES), TIME_ZONE);
                        break;
                    }
                    case SECONDS: {
                        ret = LocalDateTime.ofInstant(Instant.from(ta2).truncatedTo(ChronoUnit.SECONDS), TIME_ZONE);
                    }
                }
            }
            catch (Exception ta2) {
                // empty catch block
            }
            if (ret == null) {
                try {
                    ta2 = DateTimeFormatter.ISO_DATE.parse(src);
                    ret = LocalDate.ofInstant(Instant.from(ta2), ZoneId.systemDefault());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return ret;
        }
        return null;
    }

    public static String useExact(String s) {
        return s;
    }

    public static String normalizeText(String src) {
        if (src == null) {
            return "";
        }
        String text = src.toLowerCase().trim().replaceAll("\\s+", " ");
        return HtmlEscape.unescapeHtml((String)text);
    }

    public static enum TempPrecision {
        DATES,
        MINUTES,
        SECONDS;

    }
}

