/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.layout.map;

import cz.vutbr.fit.layout.map.Example;
import cz.vutbr.fit.layout.map.MetaRefTag;
import cz.vutbr.fit.layout.ontology.MAPPING;
import cz.vutbr.fit.layout.ontology.SEGM;
import cz.vutbr.fit.layout.rdf.RDFArtifactRepository;
import cz.vutbr.fit.layout.rdf.StorageException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.LinkedHashModel;
import org.eclipse.rdf4j.model.util.Values;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.query.Binding;
import org.eclipse.rdf4j.query.BindingSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetadataTagManager {
    private static Logger log = LoggerFactory.getLogger(MetadataTagManager.class);
    private RDFArtifactRepository repo;
    private IRI contextIri;
    private String tagIriBase;

    public MetadataTagManager(RDFArtifactRepository repo, IRI contextIri) {
        this.repo = repo;
        this.contextIri = contextIri;
        this.tagIriBase = contextIri.getLocalName();
    }

    public Collection<MetaRefTag> getMetaTags() throws StorageException {
        try {
            String query = this.repo.getIriDecoder().declarePrefixes() + "SELECT ?tag ?name ?type ?subj ?subjType ?pred WHERE {  GRAPH <" + this.contextIri + "> {    ?tag segm:name ?name .     ?tag segm:type ?type .     ?tag map:describesInstance ?subj .     ?tag map:isValueOf ?pred .     ?tag rdf:type segm:Tag .     OPTIONAL { ?subj rdf:type ?subjType } }}";
            List data = this.repo.getStorage().executeSafeTupleQuery(query);
            ArrayList<MetaRefTag> ret = new ArrayList<MetaRefTag>(data.size());
            for (BindingSet binding : data) {
                Binding bIri = binding.getBinding("tag");
                Binding bName = binding.getBinding("name");
                Binding bType = binding.getBinding("type");
                Binding bSubj = binding.getBinding("subj");
                Binding bSubjType = binding.getBinding("subjType");
                Binding bPred = binding.getBinding("pred");
                if (bIri == null || bName == null || bType == null || bSubj == null || bPred == null || !(bIri.getValue() instanceof IRI) || !(bSubj.getValue() instanceof Resource) || !(bPred.getValue() instanceof IRI)) continue;
                Example ex = new Example((Resource)bSubj.getValue(), (IRI)bPred.getValue(), "");
                if (bSubjType != null && bSubjType.getValue() instanceof IRI) {
                    ex.setSubjectType((IRI)bSubjType.getValue());
                }
                MetaRefTag tag = new MetaRefTag((IRI)bIri.getValue(), bName.getValue().stringValue(), ex);
                ret.add(tag);
            }
            return ret;
        }
        catch (Exception e) {
            throw new StorageException((Throwable)e);
        }
    }

    public Collection<MetaRefTag> createTagsForExamples(Collection<Example> examples) {
        int tagIdCnt = 1;
        ArrayList<MetaRefTag> tags = new ArrayList<MetaRefTag>();
        for (Example example : examples) {
            String tagName = example.getPredicate().getLocalName() + tagIdCnt;
            IRI tagIri = Values.iri((String)"http://fitlayout.github.io/resource/", (String)(this.tagIriBase + "-tag-meta--" + tagName));
            MetaRefTag tag = new MetaRefTag(tagIri, tagName, example);
            tags.add(tag);
            ++tagIdCnt;
        }
        return tags;
    }

    public void storeTags(Collection<MetaRefTag> tags) throws StorageException {
        ValueFactory vf = this.repo.getStorage().getValueFactory();
        LinkedHashModel graph = new LinkedHashModel();
        for (MetaRefTag tag : tags) {
            graph.add((Object)vf.createStatement((Resource)tag.getIri(), RDF.TYPE, (Value)SEGM.Tag));
            graph.add((Object)vf.createStatement((Resource)tag.getIri(), SEGM.type, (Value)vf.createLiteral(tag.getType())));
            graph.add((Object)vf.createStatement((Resource)tag.getIri(), SEGM.name, (Value)vf.createLiteral(tag.getName())));
            graph.add((Object)vf.createStatement((Resource)tag.getIri(), MAPPING.describesInstance, (Value)tag.getExample().getSubject()));
            graph.add((Object)vf.createStatement((Resource)tag.getIri(), MAPPING.isValueOf, (Value)tag.getExample().getPredicate()));
        }
        this.repo.getStorage().insertGraph((Model)graph, this.contextIri);
    }

    public Collection<MetaRefTag> checkForTags(Collection<Example> examples) {
        Collection<MetaRefTag> tags = this.getMetaTags();
        if (tags.isEmpty()) {
            Collection<MetaRefTag> newTags = this.createTagsForExamples(examples);
            this.storeTags(newTags);
            log.info("Created new tags in {} : {}", (Object)this.contextIri, newTags);
            return newTags;
        }
        log.info("Tags already present in {} : {}", (Object)this.contextIri, tags);
        return tags;
    }
}

