/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.layout.patterns;

import cz.vutbr.fit.layout.model.AreaConnection;
import cz.vutbr.fit.layout.model.AreaTopology;
import cz.vutbr.fit.layout.model.ContentRect;
import cz.vutbr.fit.layout.model.Page;
import cz.vutbr.fit.layout.model.Rectangular;
import cz.vutbr.fit.layout.model.Relation;
import cz.vutbr.fit.layout.patterns.AreaUtils;
import cz.vutbr.fit.layout.patterns.RelationAnalyzer;
import cz.vutbr.fit.layout.patterns.Relations;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class RelationAnalyzerSymmetric
extends RelationAnalyzer {
    private static final List<Relation> ANALYZED_RELATIONS = List.of(Relations.ONRIGHT, Relations.ONLEFT, Relations.AFTER, Relations.BEFORE, Relations.SAMELINE, Relations.UNDER, Relations.UNDERHEADING, Relations.BELOW, Relations.ABOVE, Relations.LINEBELOW);

    public RelationAnalyzerSymmetric(Page page, Collection<ContentRect> areas) {
        super(page, areas);
    }

    @Override
    public List<Relation> getAnalyzedRelations() {
        return ANALYZED_RELATIONS;
    }

    @Override
    public void extractConnections() {
        Collection<ContentRect> areas = this.getAreas();
        this.addSameLineConnections(areas);
        this.addBelowAboveConnections(areas);
        this.addLineBelowRelations(areas);
        this.addUnderHeadingRelations(areas);
    }

    private void addSameLineConnections(Collection<ContentRect> areas) {
        if (!areas.isEmpty()) {
            int tw = this.getPage().getWidth();
            for (ContentRect a1 : areas) {
                Rectangular b1 = a1.getBounds();
                for (ContentRect a2 : areas) {
                    float w;
                    Rectangular b2 = a2.getBounds();
                    if (a1 == a2 || b1.intersects(b2) || !AreaUtils.isOnSameLine(b2, b1)) continue;
                    float em = Math.max(a2.getTextStyle().getFontSize(), a1.getTextStyle().getFontSize());
                    int distLL = Math.max(b2.getX1() - b1.getX1(), b1.getX1() - b2.getX1());
                    int distRL = b1.getX1() - b2.getX2();
                    int distLR = b2.getX1() - b1.getX2();
                    if (distLL > 0 && (w = 1.0f - (float)distLL / (float)tw) > 0.1f) {
                        this.addAreaConnection(new AreaConnection(a1, a2, Relations.SAMELINE, w));
                    }
                    if (distRL > 0) {
                        w = 1.0f - (float)(distRL / 3) * 3.0f / (float)tw;
                        if (w > 0.1f) {
                            this.addAreaConnection(new AreaConnection(a1, a2, Relations.AFTER, w));
                        }
                    } else if (distLR > 0 && (w = 1.0f - (float)(distLR / 3) * 3.0f / (float)tw) > 0.1f) {
                        this.addAreaConnection(new AreaConnection(a1, a2, Relations.BEFORE, w));
                    }
                    if ((double)distRL > -0.2 * (double)em && (double)distRL < 0.9 * (double)em) {
                        this.addAreaConnection(new AreaConnection(a1, a2, Relations.ONRIGHT, 1.0f));
                        continue;
                    }
                    if (!((double)distLR > -0.2 * (double)em) || !((double)distLR < 0.9 * (double)em)) continue;
                    this.addAreaConnection(new AreaConnection(a1, a2, Relations.ONLEFT, 1.0f));
                }
            }
        }
    }

    private void addBelowAboveConnections(Collection<ContentRect> areas) {
        if (!areas.isEmpty()) {
            int th = this.getPage().getWidth();
            Set entries = this.getTopology().getPositionMap().entrySet();
            for (Map.Entry e1 : entries) {
                for (Map.Entry e2 : entries) {
                    ContentRect a2;
                    ContentRect a1 = (ContentRect)e1.getKey();
                    if (a1 == (a2 = (ContentRect)e2.getKey()) || a1.getBounds().intersects(a2.getBounds())) continue;
                    this.checkBelowUnder(a1, (Rectangular)e1.getValue(), a2, (Rectangular)e2.getValue(), th);
                }
            }
        }
    }

    private void checkBelowUnder(ContentRect a1, Rectangular gp1, ContentRect a2, Rectangular gp2, int th) {
        float em;
        float dist;
        Rectangular inter = gp1.intersection(new Rectangular(gp2.getX1(), gp1.getY1(), gp2.getX2(), gp1.getY2()));
        if (inter.getWidth() > Math.min(gp1.getWidth(), gp2.getWidth()) / 2 && (dist = (float)(a1.getBounds().getY1() - a2.getBounds().getY2())) >= -0.5f * (em = Math.max(a2.getTextStyle().getFontSize(), a1.getTextStyle().getFontSize()))) {
            float w = 1.0f - dist / (float)th;
            if (w > 0.1f) {
                this.addAreaConnection(new AreaConnection(a1, a2, Relations.BELOW, w));
                this.addAreaConnection(new AreaConnection(a2, a1, Relations.ABOVE, w));
            }
            if (dist < 0.8f * em) {
                this.addAreaConnection(new AreaConnection(a1, a2, Relations.UNDER, 1.0f));
            }
        }
    }

    private void addLineBelowRelations(Collection<ContentRect> areas) {
        if (!areas.isEmpty()) {
            int tw = this.getPage().getWidth();
            int th = this.getPage().getHeight();
            for (ContentRect a : areas) {
                this.findLineBelow(a, areas, tw, th);
            }
        }
    }

    private void findLineBelow(ContentRect a, Collection<ContentRect> areas, int tw, int th) {
        float maxW = 0.0f;
        ContentRect closest = null;
        for (ContentRect cand : areas) {
            float w = this.computeWeight(cand, a, tw, th);
            if (!(w > maxW)) continue;
            closest = cand;
            maxW = w;
        }
        if (closest != null) {
            HashSet<ContentRect> used = new HashSet<ContentRect>();
            for (ContentRect cand : areas) {
                if (cand != closest && !AreaUtils.isOnSameLine(cand, closest) || used.contains(cand)) continue;
                float w = this.computeWeight(cand, a, tw, th);
                this.addAreaConnection(new AreaConnection(cand, a, Relations.LINEBELOW, w));
                used.add(cand);
                if (cand.getLine() == null) continue;
                for (ContentRect sibl : cand.getLine()) {
                    if (used.contains(sibl)) continue;
                    this.addAreaConnection(new AreaConnection(sibl, a, Relations.LINEBELOW, w));
                    used.add(sibl);
                }
            }
        }
    }

    private void addUnderHeadingRelations(Collection<ContentRect> areas) {
        if (!areas.isEmpty()) {
            int tw = this.getPage().getWidth();
            int th = this.getPage().getHeight();
            for (ContentRect a : areas) {
                this.findSubordinate(a, this.getTopology(), areas, tw, th);
            }
        }
    }

    private void findSubordinate(ContentRect a, AreaTopology t, Collection<ContentRect> areas, int tw, int th) {
        float m1 = this.getMarkedness(a);
        Rectangular gp = new Rectangular(t.getPosition(a));
        ArrayList<ContentRect> candidates = new ArrayList<ContentRect>();
        while (this.expandDown(gp, t, m1, candidates)) {
        }
        for (ContentRect c : candidates) {
            float w = this.computeWeight(c, a, tw, th);
            this.addAreaConnection(new AreaConnection(c, a, Relations.UNDERHEADING, w));
        }
    }

    private boolean expandDown(Rectangular gp, AreaTopology t, float m1, List<ContentRect> destAreas) {
        int nextY = gp.getY2() + 1;
        if (nextY < t.getTopologyHeight()) {
            boolean found = false;
            int x = gp.getX1();
            while (x <= gp.getX2()) {
                Collection cands = t.findAllAreasAt(x, nextY);
                if (!cands.isEmpty()) {
                    Rectangular cgp = null;
                    for (ContentRect cand : cands) {
                        if (this.getMarkedness(cand) < m1) {
                            found = true;
                            destAreas.add(cand);
                            if (cgp == null) {
                                cgp = t.getPosition(cand);
                                continue;
                            }
                            cgp.expandToEnclose(t.getPosition(cand));
                            continue;
                        }
                        return false;
                    }
                    if (cgp == null) continue;
                    gp.expandToEnclose(cgp);
                    x += cgp.getWidth();
                    continue;
                }
                ++x;
            }
            if (!found) {
                gp.setY2(nextY);
            }
            return true;
        }
        return false;
    }

    private float getMarkedness(ContentRect cand) {
        return cand.getTextStyle().getFontSize() * 10.0f + cand.getTextStyle().getFontWeight();
    }

    private float computeWeight(ContentRect cand, ContentRect a, int tw, int th) {
        float em;
        float distX = Math.abs(cand.getBounds().getX1() - a.getBounds().getX1());
        float distY = cand.getBounds().getY1() - a.getBounds().getY2();
        if (distY >= -0.5f * (em = cand.getTextStyle().getFontSize())) {
            float ww = 1.0f - distX / (float)tw;
            float wh = 1.0f - distY / (float)th;
            float w = ww * wh;
            return w;
        }
        return 0.0f;
    }
}

