/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.layout.patterns;

import cz.vutbr.fit.layout.api.Parameter;
import cz.vutbr.fit.layout.api.ServiceException;
import cz.vutbr.fit.layout.impl.BaseArtifactService;
import cz.vutbr.fit.layout.impl.DefaultConnectionSet;
import cz.vutbr.fit.layout.model.Artifact;
import cz.vutbr.fit.layout.model.ChunkSet;
import cz.vutbr.fit.layout.model.ConnectionSet;
import cz.vutbr.fit.layout.model.ContentRect;
import cz.vutbr.fit.layout.model.Page;
import cz.vutbr.fit.layout.ontology.BOX;
import cz.vutbr.fit.layout.ontology.SEGM;
import cz.vutbr.fit.layout.patterns.RelationAnalyzer;
import cz.vutbr.fit.layout.patterns.RelationAnalyzerSymmetric;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.rdf4j.model.IRI;

public class TextChunkConnectionProvider
extends BaseArtifactService {
    public String getId() {
        return "FitLayout.TextChunkConnections";
    }

    public String getName() {
        return "Text chunk connection extractor";
    }

    public String getDescription() {
        return "Extracts various connections between text chunks.";
    }

    public List<Parameter> defineParams() {
        ArrayList<Parameter> ret = new ArrayList<Parameter>(1);
        return ret;
    }

    public IRI getConsumes() {
        return SEGM.ChunkSet;
    }

    public IRI getProduces() {
        return BOX.ConnectionSet;
    }

    public Artifact process(Artifact input) throws ServiceException {
        if (input != null && input instanceof ChunkSet) {
            ChunkSet cset = (ChunkSet)input;
            if (cset.getPageIri() != null) {
                Artifact page = this.getServiceManager().getArtifactRepository().getArtifact(cset.getPageIri());
                if (page != null && page instanceof Page) {
                    return this.extractConnections(cset, (Page)page);
                }
                throw new ServiceException("Couldn't fetch source page");
            }
            throw new ServiceException("Source page not set");
        }
        throw new ServiceException("Source artifact not specified or not a chunk set");
    }

    public ConnectionSet extractConnections(ChunkSet input, Page page) {
        HashSet<ContentRect> chunks = new HashSet<ContentRect>(input.getTextChunks());
        RelationAnalyzerSymmetric ra = new RelationAnalyzerSymmetric(page, chunks);
        ((RelationAnalyzer)ra).extractConnections();
        DefaultConnectionSet ret = new DefaultConnectionSet(input.getIri());
        ret.setAreaConnections(ra.getConnections());
        ret.setPageIri(page.getIri());
        ret.setLabel("Relations");
        ret.setCreator(this.getId());
        ret.setCreatorParams(this.getParamString());
        return ret;
    }
}

