/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.layout.patterns;

import cz.vutbr.fit.layout.api.ArtifactRepository;
import cz.vutbr.fit.layout.api.ServiceException;
import cz.vutbr.fit.layout.impl.BaseArtifactService;
import cz.vutbr.fit.layout.model.AreaConnection;
import cz.vutbr.fit.layout.patterns.ConnectionSetModelBuilder;
import cz.vutbr.fit.layout.rdf.RDFArtifactRepository;
import java.util.Collection;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Model;

public abstract class ConnectionSetArtifactService
extends BaseArtifactService {
    protected void saveConnections(IRI artifactIri, Collection<AreaConnection> cons) throws ServiceException {
        ArtifactRepository repo = this.getServiceManager().getArtifactRepository();
        if (!(repo instanceof RDFArtifactRepository)) {
            throw new ServiceException("RDFArtifactRepository is required for storing the connections");
        }
        RDFArtifactRepository rdfRepo = (RDFArtifactRepository)repo;
        ConnectionSetModelBuilder builder = new ConnectionSetModelBuilder(rdfRepo.getIriFactory());
        Model graph = builder.createModel(artifactIri, cons);
        rdfRepo.getStorage().insertGraph(graph, artifactIri);
    }
}

