/**
 * ConnectionSerModelLoader.java
 *
 * Created on 27. 12. 2021, 20:48:17 by burgetr
 */
package cz.vutbr.fit.layout.patterns;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import cz.vutbr.fit.layout.impl.DefaultRelation;
import cz.vutbr.fit.layout.model.AreaConnection;
import cz.vutbr.fit.layout.model.Artifact;
import cz.vutbr.fit.layout.model.ContentRect;
import cz.vutbr.fit.layout.model.Relation;
import cz.vutbr.fit.layout.rdf.IRIFactory;
import cz.vutbr.fit.layout.rdf.ModelLoaderBase;
import cz.vutbr.fit.layout.rdf.RDFArtifactRepository;
import cz.vutbr.fit.layout.rdf.model.RDFAreaTree;
import cz.vutbr.fit.layout.rdf.model.RDFArtifact;
import cz.vutbr.fit.layout.rdf.model.RDFChunkSet;

/**
 * 
 * @author burgetr
 */
public class ConnectionSetModelLoader extends ModelLoaderBase
{
    private static Logger log = LoggerFactory.getLogger(ConnectionSetModelLoader.class);

    public ConnectionSetModelLoader(IRIFactory iriFactory)
    {
        super(iriFactory);
    }

    public Collection<AreaConnection> constructConnectionSet(IRI csetIri, RDFArtifactRepository artifactRepo) throws RepositoryException
    {
        Model artifactModel = artifactRepo.getStorage().getSubjectModel(csetIri);
        if (artifactModel.size() > 0)
        {
            // load source artifact
            Artifact sourceArtifact = artifactRepo.getArtifact(csetIri);
            // load connections data from a complete context model
            Model completeModel = artifactRepo.getStorage().getContextModel(csetIri);
            Set<AreaConnection> conns = new HashSet<>();
            loadConnections(completeModel, csetIri, sourceArtifact, conns);
            return conns;
        }
        else
            return null;
    }
    
    private void loadConnections(Model model, IRI csetIri, Artifact sourceArtifact, Set<AreaConnection> conns)
    {
        for (Statement st : model) 
        {
            if (!st.getSubject().equals(csetIri)) // consider statements that don't describe the cset itself
            {
                if (st.getSubject() instanceof IRI && st.getObject() instanceof IRI)
                {
                    if (sourceArtifact instanceof RDFArtifact)
                    {
                        // TODO reuse predefined relations from repository metadata? 
                        final String relName = getIriFactory().decodeRelationURI(st.getPredicate());
                        final ContentRect rect1 = findContentRect((RDFArtifact) sourceArtifact, (IRI) st.getSubject());
                        final ContentRect rect2 = findContentRect((RDFArtifact) sourceArtifact, (IRI) st.getObject());
                        if (relName != null && rect1 != null && rect2 != null)
                        {
                            Relation rel = new DefaultRelation(relName);
                            AreaConnection con = new AreaConnection(rect1, rect2, rel, 1.0f); //TODO weights
                            conns.add(con);
                        }
                    }
                    else
                        log.warn("Source artifact of {} is not RDFArtifact");
                }
            }
        }
    }
    
    private ContentRect findContentRect(RDFArtifact sourceArtifact, IRI rectIri)
    {
        if (sourceArtifact instanceof RDFAreaTree)
            return ((RDFAreaTree) sourceArtifact).findAreaByIri(rectIri);
        else if (sourceArtifact instanceof RDFChunkSet)
            return ((RDFChunkSet) sourceArtifact).findTextChunkByIri(rectIri);
        else
            return null;
    }
    
}
