/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.layout.patterns;

import cz.vutbr.fit.layout.api.Parameter;
import cz.vutbr.fit.layout.api.ServiceException;
import cz.vutbr.fit.layout.model.Area;
import cz.vutbr.fit.layout.model.AreaConnection;
import cz.vutbr.fit.layout.model.AreaTree;
import cz.vutbr.fit.layout.model.Artifact;
import cz.vutbr.fit.layout.model.ContentRect;
import cz.vutbr.fit.layout.model.Page;
import cz.vutbr.fit.layout.ontology.SEGM;
import cz.vutbr.fit.layout.patterns.ConnectionSetArtifactService;
import cz.vutbr.fit.layout.patterns.RelationAnalyzer;
import cz.vutbr.fit.layout.patterns.RelationAnalyzerSymmetric;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.rdf4j.model.IRI;

public class AreaConnectionProvider
extends ConnectionSetArtifactService {
    public String getId() {
        return "FitLayout.AreaConnections";
    }

    public String getName() {
        return "Area connection extractor";
    }

    public String getDescription() {
        return "Extracts various connections between visual areas.";
    }

    public List<Parameter> defineParams() {
        ArrayList<Parameter> ret = new ArrayList<Parameter>(1);
        return ret;
    }

    public IRI getConsumes() {
        return SEGM.AreaTree;
    }

    public IRI getProduces() {
        return null;
    }

    public String getCategory() {
        return "Relations";
    }

    public Artifact process(Artifact input) throws ServiceException {
        if (input != null && input instanceof AreaTree) {
            AreaTree atree = (AreaTree)input;
            if (atree.getPageIri() != null) {
                Artifact page = this.getServiceManager().getArtifactRepository().getArtifact(atree.getPageIri());
                if (page != null && page instanceof Page) {
                    Collection<AreaConnection> conns = this.extractConnections(atree, (Page)page);
                    this.saveConnections(input.getIri(), conns);
                    return null;
                }
                throw new ServiceException("Couldn't fetch source page");
            }
            throw new ServiceException("Source page not set");
        }
        throw new ServiceException("Source artifact not specified or not an area tree");
    }

    public Collection<AreaConnection> extractConnections(AreaTree input, Page page) {
        ArrayList<ContentRect> leafAreas = new ArrayList<ContentRect>();
        this.findLeafAreas(input.getRoot(), leafAreas);
        RelationAnalyzerSymmetric ra = new RelationAnalyzerSymmetric(page, leafAreas);
        ((RelationAnalyzer)ra).extractConnections();
        return ra.getConnections();
    }

    private void findLeafAreas(Area root, List<ContentRect> areas) {
        if (root.isLeaf()) {
            areas.add((ContentRect)root);
        } else {
            for (Area child : root.getChildren()) {
                this.findLeafAreas(child, areas);
            }
        }
    }
}

