/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.layout.patterns;

import cz.vutbr.fit.layout.impl.DefaultRelation;
import cz.vutbr.fit.layout.model.AreaConnection;
import cz.vutbr.fit.layout.model.Artifact;
import cz.vutbr.fit.layout.model.ContentRect;
import cz.vutbr.fit.layout.model.Relation;
import cz.vutbr.fit.layout.rdf.IRIFactory;
import cz.vutbr.fit.layout.rdf.ModelLoaderBase;
import cz.vutbr.fit.layout.rdf.RDFArtifactRepository;
import cz.vutbr.fit.layout.rdf.model.RDFAreaTree;
import cz.vutbr.fit.layout.rdf.model.RDFArtifact;
import cz.vutbr.fit.layout.rdf.model.RDFChunkSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionSetModelLoader
extends ModelLoaderBase {
    private static Logger log = LoggerFactory.getLogger(ConnectionSetModelLoader.class);

    public ConnectionSetModelLoader(IRIFactory iriFactory) {
        super(iriFactory);
    }

    public Collection<AreaConnection> constructConnectionSet(IRI csetIri, RDFArtifactRepository artifactRepo) throws RepositoryException {
        Model artifactModel = artifactRepo.getStorage().getSubjectModel((Resource)csetIri);
        if (artifactModel.size() > 0) {
            Artifact sourceArtifact = artifactRepo.getArtifact(csetIri);
            Model completeModel = artifactRepo.getStorage().getContextModel((Resource)csetIri);
            HashSet<AreaConnection> conns = new HashSet<AreaConnection>();
            this.loadConnections(completeModel, csetIri, sourceArtifact, conns);
            return conns;
        }
        return null;
    }

    private void loadConnections(Model model, IRI csetIri, Artifact sourceArtifact, Set<AreaConnection> conns) {
        for (Statement st : model) {
            if (st.getSubject().equals(csetIri) || !(st.getSubject() instanceof IRI) || !(st.getObject() instanceof IRI)) continue;
            if (sourceArtifact instanceof RDFArtifact) {
                String relName = this.getIriFactory().decodeRelationURI(st.getPredicate());
                ContentRect rect1 = this.findContentRect((RDFArtifact)sourceArtifact, (IRI)st.getSubject());
                ContentRect rect2 = this.findContentRect((RDFArtifact)sourceArtifact, (IRI)st.getObject());
                if (relName == null || rect1 == null || rect2 == null) continue;
                DefaultRelation rel = new DefaultRelation(relName);
                AreaConnection con = new AreaConnection(rect1, rect2, (Relation)rel, 1.0f);
                conns.add(con);
                continue;
            }
            log.warn("Source artifact of {} is not RDFArtifact");
        }
    }

    private ContentRect findContentRect(RDFArtifact sourceArtifact, IRI rectIri) {
        if (sourceArtifact instanceof RDFAreaTree) {
            return ((RDFAreaTree)sourceArtifact).findAreaByIri(rectIri);
        }
        if (sourceArtifact instanceof RDFChunkSet) {
            return ((RDFChunkSet)sourceArtifact).findTextChunkByIri(rectIri);
        }
        return null;
    }
}

