/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.layout.patterns;

import cz.vutbr.fit.layout.impl.AreaListGridTopology;
import cz.vutbr.fit.layout.model.AreaConnection;
import cz.vutbr.fit.layout.model.AreaTopology;
import cz.vutbr.fit.layout.model.ContentRect;
import cz.vutbr.fit.layout.model.Page;
import cz.vutbr.fit.layout.model.Relation;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public abstract class RelationAnalyzer {
    private float minRelationWeight;
    private Page page;
    private Collection<ContentRect> areas;
    private AreaTopology topology;
    private Set<AreaConnection> connections;

    public RelationAnalyzer(Page page, Collection<ContentRect> areas) {
        this.page = page;
        this.areas = areas;
        this.topology = new AreaListGridTopology(areas);
        this.connections = new HashSet<AreaConnection>();
        this.minRelationWeight = 0.1f;
    }

    public float getMinRelationWeight() {
        return this.minRelationWeight;
    }

    public void setMinRelationWeight(float minRelationWeight) {
        this.minRelationWeight = minRelationWeight;
    }

    public abstract List<Relation> getAnalyzedRelations();

    public abstract void extractConnections();

    protected void addAreaConnection(AreaConnection conn) {
        this.connections.add(conn);
    }

    public Set<AreaConnection> getConnections() {
        return this.connections;
    }

    public Page getPage() {
        return this.page;
    }

    public Collection<ContentRect> getAreas() {
        return this.areas;
    }

    public AreaTopology getTopology() {
        return this.topology;
    }
}

