/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.layout.patterns;

import cz.vutbr.fit.layout.model.Area;
import cz.vutbr.fit.layout.model.AreaConnection;
import cz.vutbr.fit.layout.model.ContentRect;
import cz.vutbr.fit.layout.model.TextChunk;
import cz.vutbr.fit.layout.ontology.SEGM;
import cz.vutbr.fit.layout.rdf.IRIFactory;
import cz.vutbr.fit.layout.rdf.ModelBuilderBase;
import java.util.Collection;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.LinkedHashModel;

public class ConnectionSetModelBuilder
extends ModelBuilderBase {
    public ConnectionSetModelBuilder(IRIFactory iriFactory) {
        super(iriFactory);
    }

    public Model createModel(IRI artifactIri, Collection<AreaConnection> conns) {
        LinkedHashModel graph = new LinkedHashModel();
        this.addConnections(artifactIri, conns, (Model)graph);
        return graph;
    }

    private void addConnections(IRI sourceIri, Collection<AreaConnection> conns, Model graph) {
        for (AreaConnection con : conns) {
            this.addConnection(sourceIri, con, graph);
        }
    }

    private void addConnection(IRI artifactIri, AreaConnection con, Model graph) {
        IRI iri1 = this.getContentRectIRI(artifactIri, (ContentRect)con.getA1());
        IRI iri2 = this.getContentRectIRI(artifactIri, (ContentRect)con.getA2());
        if (iri1 != null && iri2 != null) {
            IRI relationIri = this.getIriFactory().createRelationURI(con.getRelation());
            graph.add((Resource)iri1, relationIri, (Value)iri2, new Resource[0]);
            IRI descrIri = this.getIriFactory().createRelationDescriptionURI(iri1, iri2, con.getRelation());
            graph.add((Resource)iri1, SEGM.isInRelation, (Value)descrIri, new Resource[0]);
            graph.add((Resource)descrIri, SEGM.hasRelatedRect, (Value)iri2, new Resource[0]);
            graph.add((Resource)descrIri, SEGM.hasRelationType, (Value)relationIri, new Resource[0]);
            graph.add((Resource)descrIri, SEGM.support, (Value)this.getValueFactory().createLiteral(con.getWeight()), new Resource[0]);
        }
    }

    private IRI getContentRectIRI(IRI artifactIri, ContentRect rect) {
        if (rect instanceof Area) {
            return this.getAreaIri(artifactIri, (Area)rect);
        }
        if (rect instanceof TextChunk) {
            return this.getTextChunkIri(artifactIri, (TextChunk)rect);
        }
        return null;
    }
}

