/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.layout.patterns;

import cz.vutbr.fit.layout.impl.DefaultRelation;
import cz.vutbr.fit.layout.model.AreaConnection;
import cz.vutbr.fit.layout.model.Artifact;
import cz.vutbr.fit.layout.model.ContentRect;
import cz.vutbr.fit.layout.model.Relation;
import cz.vutbr.fit.layout.rdf.IRIFactory;
import cz.vutbr.fit.layout.rdf.ModelLoaderBase;
import cz.vutbr.fit.layout.rdf.RDFArtifactRepository;
import cz.vutbr.fit.layout.rdf.StorageException;
import cz.vutbr.fit.layout.rdf.model.RDFAreaTree;
import cz.vutbr.fit.layout.rdf.model.RDFArtifact;
import cz.vutbr.fit.layout.rdf.model.RDFChunkSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.rdf4j.common.exception.RDF4JException;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionSetModelLoader
extends ModelLoaderBase {
    private static Logger log = LoggerFactory.getLogger(ConnectionSetModelLoader.class);

    public ConnectionSetModelLoader(IRIFactory iriFactory) {
        super(iriFactory);
    }

    public Collection<AreaConnection> constructConnectionSet(IRI csetIri, RDFArtifactRepository artifactRepo) throws RepositoryException {
        Model artifactModel = artifactRepo.getStorage().getSubjectModel((Resource)csetIri);
        if (artifactModel.size() > 0) {
            Artifact sourceArtifact = artifactRepo.getArtifact(csetIri);
            HashSet<AreaConnection> conns = new HashSet<AreaConnection>();
            this.loadConnections(sourceArtifact, artifactRepo, conns);
            return conns;
        }
        return null;
    }

    private void loadConnections(Artifact sourceArtifact, RDFArtifactRepository artifactRepo, Set<AreaConnection> conns) {
        if (sourceArtifact instanceof RDFArtifact) {
            try {
                String query = "PREFIX segm: <http://fitlayout.github.io/ontology/segmentation.owl#>\nPREFIX r: <http://fitlayout.github.io/resource/>\nSELECT ?a ?b ?r ?w WHERE {\n  ?a segm:belongsTo <" + sourceArtifact.getIri().toString() + ">\n  ?a segm:isInRelation ?descr .\n  ?descr segm:hasRelatedRect ?b .\n  ?descr segm:hasRelationType ?r .\n  ?descr segm:support ?w\n}\n";
                List data = artifactRepo.getStorage().executeSafeTupleQuery(query);
                for (BindingSet binding : data) {
                    Value va = binding.getBinding("a").getValue();
                    Value vb = binding.getBinding("b").getValue();
                    Value vr = binding.getBinding("r").getValue();
                    Value vw = binding.getBinding("w").getValue();
                    if (va == null || vb == null || vr == null || vw == null || !va.isIRI() || !vb.isIRI() || !vr.isIRI() || !vw.isLiteral()) continue;
                    float w = 1.0f;
                    try {
                        w = ((Literal)vw).floatValue();
                    }
                    catch (NumberFormatException e) {
                        continue;
                    }
                    String relName = this.getIriFactory().decodeRelationURI((IRI)vr);
                    ContentRect rect1 = this.findContentRect((RDFArtifact)sourceArtifact, (IRI)va);
                    ContentRect rect2 = this.findContentRect((RDFArtifact)sourceArtifact, (IRI)vb);
                    if (relName == null || rect1 == null || rect2 == null) continue;
                    DefaultRelation rel = new DefaultRelation(relName);
                    AreaConnection con = new AreaConnection(rect1, rect2, (Relation)rel, w);
                    conns.add(con);
                }
            }
            catch (RDF4JException e) {
                throw new StorageException((Throwable)e);
            }
        }
        log.warn("Source artifact {} is not RDFArtifact", (Object)sourceArtifact.getIri());
    }

    private ContentRect findContentRect(RDFArtifact sourceArtifact, IRI rectIri) {
        if (sourceArtifact instanceof RDFAreaTree) {
            return ((RDFAreaTree)sourceArtifact).findAreaByIri(rectIri);
        }
        if (sourceArtifact instanceof RDFChunkSet) {
            return ((RDFChunkSet)sourceArtifact).findTextChunkByIri(rectIri);
        }
        return null;
    }
}

