/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.layout.patterns;

import cz.vutbr.fit.layout.api.AreaUtils;
import cz.vutbr.fit.layout.impl.AreaListPixelTopology;
import cz.vutbr.fit.layout.model.Area;
import cz.vutbr.fit.layout.model.AreaConnection;
import cz.vutbr.fit.layout.model.AreaTopology;
import cz.vutbr.fit.layout.model.ChunkSet;
import cz.vutbr.fit.layout.model.ContentRect;
import cz.vutbr.fit.layout.model.Rectangular;
import cz.vutbr.fit.layout.model.Relation;
import cz.vutbr.fit.layout.model.TextChunk;
import cz.vutbr.fit.layout.patterns.RelationAnalyzer;
import cz.vutbr.fit.layout.patterns.Relations;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class RelationAnalyzerAligned
implements RelationAnalyzer {
    private static final List<Relation> ANALYZED_RELATIONS = List.of(Relations.ONRIGHT, Relations.ONLEFT, Relations.BELOW, Relations.ABOVE);
    private Area rootArea;
    private ChunkSet chunkSet;
    private Set<AreaConnection> connections;

    public RelationAnalyzerAligned(Area rootArea) {
        this.rootArea = rootArea;
        this.connections = new HashSet<AreaConnection>();
    }

    public RelationAnalyzerAligned(ChunkSet chunkSet) {
        this.chunkSet = chunkSet;
        this.connections = new HashSet<AreaConnection>();
    }

    @Override
    public List<Relation> getAnalyzedRelations() {
        return ANALYZED_RELATIONS;
    }

    @Override
    public void extractConnections() {
        if (this.rootArea != null) {
            this.recursiveExtractConnections(this.rootArea);
        } else if (this.chunkSet != null) {
            this.extractConnectionsInChunkSet(this.chunkSet);
        }
    }

    @Override
    public Set<AreaConnection> getConnections() {
        return this.connections;
    }

    private void recursiveExtractConnections(Area root) {
        if (root.getChildCount() > 1) {
            this.extractConnectionsInArea(root);
        }
        for (Area child : root.getChildren()) {
            this.recursiveExtractConnections(child);
        }
    }

    private void extractConnectionsInArea(Area parent) {
        List rects = AreaUtils.getChildrenAsContentRects((Area)parent);
        Rectangular parentBounds = parent.getBounds();
        this.extractConnectionsFromList(rects, parentBounds);
    }

    private void extractConnectionsInChunkSet(ChunkSet chunkSet) {
        ArrayList<ContentRect> rects = new ArrayList<ContentRect>();
        int maxX = 0;
        int maxY = 0;
        for (TextChunk textChunk : chunkSet.getTextChunks()) {
            Rectangular pos = textChunk.getBounds();
            maxX = Math.max(maxX, pos.getX2());
            maxY = Math.max(maxY, pos.getY2());
            rects.add((ContentRect)textChunk);
        }
        this.extractConnectionsFromList(rects, new Rectangular(0, 0, maxX, maxY));
    }

    protected void extractConnectionsFromList(List<ContentRect> rects, Rectangular parentBounds) {
        AreaListPixelTopology topology = new AreaListPixelTopology(rects, parentBounds);
        for (ContentRect src : rects) {
            Rectangular pos = src.getBounds();
            this.addFromRegion((AreaTopology)topology, src, new Rectangular(pos.getX2() + 1, pos.getY1() + 1, parentBounds.getX2(), pos.getY2() - 1), Relations.ONLEFT, true);
            this.addFromRegion((AreaTopology)topology, src, new Rectangular(pos.getX1() + 1, pos.getY2() + 1, pos.getX2() - 1, parentBounds.getY2()), Relations.ABOVE, false);
        }
    }

    private void addFromRegion(AreaTopology topology, ContentRect src, Rectangular region, Relation rel, boolean isHorizontal) {
        Collection all = topology.findAllAreasIntersecting(region);
        int minDist = Integer.MAX_VALUE;
        for (ContentRect cand : all) {
            int dist = this.rectDistance(cand, src, isHorizontal);
            minDist = Math.min(dist, minDist);
        }
        ArrayList<ContentRect> selected = new ArrayList<ContentRect>();
        if (minDist != Integer.MAX_VALUE) {
            for (ContentRect cand : all) {
                if (this.rectDistance(cand, src, isHorizontal) != minDist) continue;
                selected.add(cand);
            }
        }
        for (ContentRect cand : selected) {
            if (cand == src) continue;
            this.addAreaConnection(new AreaConnection(src, cand, rel, (float)minDist));
            if (rel.getInverse() == null) continue;
            this.addAreaConnection(new AreaConnection(cand, src, rel.getInverse(), (float)minDist));
        }
    }

    protected void addAreaConnection(AreaConnection conn) {
        this.connections.add(conn);
    }

    protected int rectDistance(ContentRect a1, ContentRect a2, boolean isHorizontal) {
        if (a1 != a2) {
            Rectangular r1 = a1.getBounds();
            Rectangular r2 = a2.getBounds();
            if (isHorizontal) {
                if (r1.getX2() <= r2.getX1()) {
                    return r2.getX1() - r1.getX2();
                }
                if (r2.getX2() <= r1.getX1()) {
                    return r1.getX1() - r2.getX2();
                }
                return Integer.MAX_VALUE;
            }
            if (r1.getY2() <= r2.getY1()) {
                return r2.getY1() - r1.getY2();
            }
            if (r2.getY2() <= r1.getY1()) {
                return r1.getY1() - r2.getY2();
            }
            return Integer.MAX_VALUE;
        }
        return Integer.MAX_VALUE;
    }
}

