/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.layout.patterns;

import cz.vutbr.fit.layout.api.Parameter;
import cz.vutbr.fit.layout.api.ServiceException;
import cz.vutbr.fit.layout.impl.ParameterFloat;
import cz.vutbr.fit.layout.impl.ParameterString;
import cz.vutbr.fit.layout.model.AreaConnection;
import cz.vutbr.fit.layout.model.Artifact;
import cz.vutbr.fit.layout.model.ChunkSet;
import cz.vutbr.fit.layout.model.ContentRect;
import cz.vutbr.fit.layout.model.Page;
import cz.vutbr.fit.layout.ontology.SEGM;
import cz.vutbr.fit.layout.patterns.ConnectionSetArtifactService;
import cz.vutbr.fit.layout.patterns.RelationAnalyzerAligned;
import cz.vutbr.fit.layout.patterns.RelationAnalyzerSymmetric;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.rdf4j.model.IRI;

public class TextChunkConnectionProvider
extends ConnectionSetArtifactService {
    private float minRelationWeight = 0.1f;
    private String method = "symmetric";

    public float getMinRelationWeight() {
        return this.minRelationWeight;
    }

    public void setMinRelationWeight(float minRelationWeight) {
        this.minRelationWeight = minRelationWeight;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public String getId() {
        return "FitLayout.TextChunkConnections";
    }

    public String getName() {
        return "Text chunk connection extractor";
    }

    public String getDescription() {
        return "Extracts various connections between text chunks.";
    }

    public List<Parameter> defineParams() {
        ArrayList<Parameter> ret = new ArrayList<Parameter>(2);
        ret.add((Parameter)new ParameterFloat("minRelationWeight", "Minimal required weight of extracted relations", -1000.0f, 1000.0f));
        ret.add((Parameter)new ParameterString("method", "Used analysis method {symmetric, aligned}", 1, 32));
        return ret;
    }

    public IRI getConsumes() {
        return SEGM.ChunkSet;
    }

    public IRI getProduces() {
        return null;
    }

    public String getCategory() {
        return "Relations";
    }

    public Artifact process(Artifact input) throws ServiceException {
        if (input != null && input instanceof ChunkSet) {
            ChunkSet cset = (ChunkSet)input;
            if (cset.getPageIri() != null) {
                Artifact page = this.getServiceManager().getArtifactRepository().getArtifact(cset.getPageIri());
                if (page != null && page instanceof Page) {
                    Collection<AreaConnection> conns = this.extractConnections(cset, (Page)page);
                    this.saveConnections(input.getIri(), conns);
                    return null;
                }
                throw new ServiceException("Couldn't fetch source page");
            }
            throw new ServiceException("Source page not set");
        }
        throw new ServiceException("Source artifact not specified or not a chunk set");
    }

    public Collection<AreaConnection> extractConnections(ChunkSet input, Page page) {
        switch (this.method) {
            case "symmetric": {
                return this.extractConnectionsSymmetric(input, page);
            }
            case "aligned": {
                return this.extractConnectionsAligned(input, page);
            }
        }
        throw new ServiceException("Unsupported analysis method, use {symmetric, aligned}");
    }

    public Collection<AreaConnection> extractConnectionsSymmetric(ChunkSet input, Page page) {
        HashSet<ContentRect> chunks = new HashSet<ContentRect>(input.getTextChunks());
        RelationAnalyzerSymmetric ra = new RelationAnalyzerSymmetric(page, chunks);
        ra.setMinRelationWeight(this.minRelationWeight);
        ra.extractConnections();
        return ra.getConnections();
    }

    public Collection<AreaConnection> extractConnectionsAligned(ChunkSet input, Page page) {
        RelationAnalyzerAligned ra = new RelationAnalyzerAligned(input);
        ra.extractConnections();
        return ra.getConnections();
    }
}

