/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.layout.cssbox.impl;

import cz.vutbr.fit.layout.cssbox.impl.BoxTransform;
import cz.vutbr.fit.layout.cssbox.impl.ContentImageImpl;
import cz.vutbr.fit.layout.cssbox.impl.RectangularZ;
import cz.vutbr.fit.layout.cssbox.impl.Units;
import cz.vutbr.fit.layout.impl.DefaultBox;
import cz.vutbr.fit.layout.model.Border;
import cz.vutbr.fit.layout.model.Box;
import cz.vutbr.fit.layout.model.ContentObject;
import cz.vutbr.fit.layout.model.Rectangular;
import cz.vutbr.fit.layout.model.TextStyle;
import cz.vutbr.web.css.CSSProperty;
import cz.vutbr.web.css.NodeData;
import cz.vutbr.web.css.TermColor;
import cz.vutbr.web.csskit.Color;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.rdf4j.model.IRI;
import org.fit.cssbox.css.CSSUnits;
import org.fit.cssbox.layout.ElementBox;
import org.fit.cssbox.layout.ReplacedBox;
import org.fit.cssbox.layout.ReplacedContent;
import org.fit.cssbox.layout.ReplacedImage;
import org.fit.cssbox.layout.TextBox;
import org.fit.cssbox.layout.Viewport;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class BoxNode
extends DefaultBox {
    protected org.fit.cssbox.layout.Box box;
    protected BoxTransform transform;
    private float zoom;

    public BoxNode(org.fit.cssbox.layout.Box box, IRI pageIri, float zoom) {
        this(box, pageIri, null, zoom);
    }

    public BoxNode(org.fit.cssbox.layout.Box box, IRI pageIri, cz.vutbr.fit.layout.model.Color bgColor, float zoom) {
        this.box = box;
        this.zoom = zoom;
        this.setBackgroundColor(bgColor);
        this.setPageIri(pageIri);
        if (box != null) {
            this.loadBoxProperties();
            this.transform = new BoxTransform(box);
        }
    }

    public String toString() {
        org.fit.cssbox.layout.Box box = this.getBox();
        Object ret = "";
        ret = (String)ret + this.getOrder() + ": ";
        if (box == null) {
            ret = (String)ret + "- empty -";
        } else if (box instanceof Viewport) {
            ret = (String)ret + box.toString();
        } else if (box instanceof ElementBox) {
            ElementBox elem = (ElementBox)box;
            ret = (String)ret + elem.getElement().getTagName();
            ret = (String)ret + " [" + elem.getElement().getAttribute("id") + "]";
            ret = (String)ret + " [" + elem.getElement().getAttribute("class") + "]";
            ret = (String)ret + " B" + this.getBounds().toString();
            if (this.getVisualBounds() != null) {
                ret = (String)ret + " V" + this.getVisualBounds().toString();
            }
        } else if (box instanceof TextBox) {
            ret = ((TextBox)box).getText();
            ret = (String)ret + " (" + box.getAbsoluteBounds().x + "," + box.getAbsoluteBounds().y + "," + (box.getAbsoluteBounds().x + box.getAbsoluteBounds().width - 1.0f) + "," + (box.getAbsoluteBounds().y + box.getAbsoluteBounds().height - 1.0f) + ")";
        } else {
            ret = "?: " + box.toString();
        }
        return ret;
    }

    public boolean equals(Object obj) {
        if (obj instanceof BoxNode) {
            return ((BoxNode)((Object)obj)).getBox() == this.getBox();
        }
        return false;
    }

    private void loadBoxProperties() {
        this.setType(this.getIntrinsicType());
        this.setBounds(new Rectangular(this.getIntrinsicBounds()));
        this.setContentBounds(new Rectangular(this.getIntrinsicBounds()));
        this.setOwnText(this.recursiveGetText(this));
        for (Border.Side side : Border.Side.values()) {
            this.setBorderStyle(side, this.getIntrinsicBorderStyle(side));
        }
        this.setColor(this.getIntrinsicColor());
        this.setFontFamily(this.getIntrinsicFontFamily());
        this.setContentObject(this.getIntrinsicContentObject());
        this.setBackgroundSeparated(this.box instanceof ElementBox && ((ElementBox)this.box).getBgcolor() != null);
    }

    public Rectangular getIntrinsicBounds() {
        org.fit.cssbox.layout.Box box = this.getBox();
        RectangularZ ret = null;
        if (box instanceof Viewport) {
            ret = new RectangularZ(((Viewport)box).getClippedBounds(), this.zoom);
        } else if (box instanceof ElementBox) {
            ElementBox elem = (ElementBox)box;
            ret = new RectangularZ(elem.getAbsoluteBorderBounds().intersection(elem.getClipBlock().getClippedContentBounds()), this.zoom);
        } else {
            ret = new RectangularZ(box.getAbsoluteBounds().intersection(box.getClipBlock().getClippedContentBounds()), this.zoom);
        }
        return ret;
    }

    public int getIntrinsicTopBorder() {
        org.fit.cssbox.layout.Box box = this.getBox();
        if (box instanceof ElementBox) {
            return this.zoom(((ElementBox)box).getBorder().top);
        }
        return 0;
    }

    public int getIntrinsicBottomBorder() {
        org.fit.cssbox.layout.Box box = this.getBox();
        if (box instanceof ElementBox) {
            return this.zoom(((ElementBox)box).getBorder().bottom);
        }
        return 0;
    }

    public int getIntrinsicLeftBorder() {
        org.fit.cssbox.layout.Box box = this.getBox();
        if (box instanceof ElementBox) {
            return this.zoom(((ElementBox)box).getBorder().left);
        }
        return 0;
    }

    public int getIntrinsicRightBorder() {
        org.fit.cssbox.layout.Box box = this.getBox();
        if (box instanceof ElementBox) {
            return this.zoom(((ElementBox)box).getBorder().right);
        }
        return 0;
    }

    public Border getIntrinsicBorderStyle(Border.Side side) {
        org.fit.cssbox.layout.Box box = this.getBox();
        if (box instanceof ElementBox) {
            Border.Style rstyle;
            NodeData style = ((ElementBox)box).getStyle();
            TermColor tclr = (TermColor)style.getValue(TermColor.class, "border-" + side + "-color");
            CSSProperty.BorderStyle bst = (CSSProperty.BorderStyle)style.getProperty("border-" + side + "-style");
            if (bst == null) {
                bst = CSSProperty.BorderStyle.NONE;
            }
            cz.vutbr.fit.layout.model.Color clr = null;
            if (tclr != null) {
                clr = Units.toColor((Color)tclr.getValue());
            }
            if (clr == null && (clr = Units.toColor(box.getVisualContext().getColor())) == null) {
                clr = cz.vutbr.fit.layout.model.Color.BLACK;
            }
            int rwidth = 0;
            switch (side) {
                case BOTTOM: {
                    rwidth = this.getIntrinsicBottomBorder();
                    break;
                }
                case LEFT: {
                    rwidth = this.getIntrinsicLeftBorder();
                    break;
                }
                case RIGHT: {
                    rwidth = this.getIntrinsicRightBorder();
                    break;
                }
                case TOP: {
                    rwidth = this.getIntrinsicTopBorder();
                }
            }
            switch (bst) {
                case NONE: 
                case HIDDEN: {
                    rstyle = Border.Style.NONE;
                    break;
                }
                case DASHED: {
                    rstyle = Border.Style.DASHED;
                    break;
                }
                case DOTTED: {
                    rstyle = Border.Style.DOTTED;
                    break;
                }
                case DOUBLE: {
                    rstyle = Border.Style.DOUBLE;
                    break;
                }
                default: {
                    rstyle = Border.Style.SOLID;
                }
            }
            return new Border(rwidth, rstyle, clr);
        }
        return new Border();
    }

    public org.fit.cssbox.layout.Box getBox() {
        return this.box;
    }

    private String recursiveGetText(BoxNode root) {
        org.fit.cssbox.layout.Box box = root.getBox();
        if (box instanceof TextBox) {
            return ((TextBox)box).getText();
        }
        Object ret = "";
        for (int i = 0; i < root.getChildCount(); ++i) {
            if (((String)ret).trim().length() > 0) {
                ret = (String)ret + " ";
            }
            ret = (String)ret + this.recursiveGetText((BoxNode)root.getChildAt(i)).trim();
        }
        return ret;
    }

    protected void recomputeTextStyle() {
        TextStyle textStyle = this.getTextStyle();
        if (textStyle == null) {
            textStyle = new TextStyle();
            this.setTextStyle(textStyle);
        } else {
            textStyle.reset();
        }
        if (this.isLeaf()) {
            int len = this.getText().trim().length();
            textStyle.setFontSizeSum(this.getIntrinsicFontSize() * (float)len);
            textStyle.setFontWeightSum(this.getIntrinsicFontWeight() * (float)len);
            textStyle.setFontStyleSum(this.getIntrinsicFontStyle() * (float)len);
            textStyle.setUnderlineSum(this.getIntrinsicUnderline() * (float)len);
            textStyle.setLineThroughSum(this.getIntrinsicLineThrough() * (float)len);
            textStyle.setContentLength(len);
        } else {
            for (Box box : this.getChildren()) {
                textStyle.updateAverages(box.getTextStyle());
            }
        }
    }

    public float getIntrinsicFontSize() {
        return CSSUnits.pixels((float)this.getBox().getVisualContext().getFontSize());
    }

    public float getIntrinsicFontStyle() {
        return this.getBox().getVisualContext().getFontInfo().isItalic() ? 1.0f : 0.0f;
    }

    public float getIntrinsicFontWeight() {
        return this.getBox().getVisualContext().getFontInfo().isBold() ? 1.0f : 0.0f;
    }

    public float getIntrinsicUnderline() {
        return this.getBox().getVisualContext().getTextDecoration().contains(CSSProperty.TextDecoration.UNDERLINE) ? 1.0f : 0.0f;
    }

    public float getIntrinsicLineThrough() {
        return this.getBox().getVisualContext().getTextDecoration().contains(CSSProperty.TextDecoration.LINE_THROUGH) ? 1.0f : 0.0f;
    }

    public cz.vutbr.fit.layout.model.Color getIntrinsicColor() {
        return Units.toColor(this.getBox().getVisualContext().getColor());
    }

    public String getIntrinsicFontFamily() {
        return this.getBox().getVisualContext().getFontInfo().getFamily();
    }

    public ContentObject getIntrinsicContentObject() {
        if (this.getBox().isReplaced()) {
            ReplacedContent content = ((ReplacedBox)this.getBox()).getContentObj();
            if (content instanceof ReplacedImage) {
                return new ContentImageImpl((ReplacedImage)content);
            }
            return null;
        }
        return null;
    }

    public Box.Type getIntrinsicType() {
        if (this.getBox().isReplaced()) {
            return Box.Type.REPLACED_CONTENT;
        }
        if (this.getBox() instanceof TextBox) {
            return Box.Type.TEXT_CONTENT;
        }
        return Box.Type.ELEMENT;
    }

    public Node getDOMNode() {
        return this.getBox().getNode();
    }

    public int getSourceNodeId() {
        return System.identityHashCode(this.getBox().getNode());
    }

    public String getTagName() {
        Node node = this.getDOMNode();
        if (node != null && node.getNodeType() == 1) {
            return ((Element)node).getTagName().toLowerCase();
        }
        return null;
    }

    public String getAttribute(String name) {
        Node node = this.getDOMNode();
        if (node != null) {
            if ("href".equals(name)) {
                return this.getAncestorAttribute(node, "a", name);
            }
            return this.getElementAttribute(node, name);
        }
        return null;
    }

    public Map<String, String> getAttributes() {
        String href;
        Node pnode;
        Node node = this.getDOMNode();
        NamedNodeMap map = null;
        if (node.getNodeType() == 1) {
            map = node.getAttributes();
        } else if (node.getNodeType() == 3 && (pnode = node.getParentNode()) != null && pnode.getNodeType() == 1) {
            map = pnode.getAttributes();
        }
        HashMap<String, String> ret = new HashMap<String, String>(map == null ? 1 : map.getLength() + 1);
        if (map != null) {
            for (int i = 0; i < map.getLength(); ++i) {
                Node attr = map.item(i);
                ret.put(attr.getNodeName(), attr.getNodeValue());
            }
        }
        if (!ret.containsKey("href") && (href = this.getAncestorAttribute(node, "a", "href")) != null) {
            ret.put("href", href);
        }
        return ret;
    }

    protected String getElementAttribute(Node node, String attrName) {
        if (node.getNodeType() == 1) {
            Element el = (Element)node;
            if (el.hasAttribute(attrName)) {
                return el.getAttribute(attrName);
            }
            return null;
        }
        if (node.getNodeType() == 3) {
            Node pnode = node.getParentNode();
            if (pnode != null && pnode.getNodeType() == 1) {
                Element parent = (Element)pnode;
                if (parent.hasAttribute(attrName)) {
                    return parent.getAttribute(attrName);
                }
                return null;
            }
            return null;
        }
        return null;
    }

    protected String getAncestorAttribute(Node node, String elementName, String attrName) {
        Node cur = node;
        while (cur.getNodeType() != 1 || !elementName.equals(cur.getNodeName())) {
            if ((cur = cur.getParentNode()) != null) continue;
            return null;
        }
        Element el = (Element)cur;
        if (el.hasAttribute(attrName)) {
            return el.getAttribute(attrName);
        }
        return null;
    }

    public Box.DisplayType getDisplayType() {
        org.fit.cssbox.layout.Box box = this.getBox();
        if (box instanceof ElementBox) {
            CSSProperty.Display display = ((ElementBox)box).getDisplay();
            if (display == null) {
                return Box.DisplayType.BLOCK;
            }
            switch (display) {
                case BLOCK: {
                    return Box.DisplayType.BLOCK;
                }
                case INLINE: {
                    return Box.DisplayType.INLINE;
                }
                case INLINE_BLOCK: {
                    return Box.DisplayType.INLINE_BLOCK;
                }
                case INLINE_TABLE: {
                    return Box.DisplayType.INLINE_TABLE;
                }
                case LIST_ITEM: {
                    return Box.DisplayType.LIST_ITEM;
                }
                case NONE: {
                    return Box.DisplayType.NONE;
                }
                case RUN_IN: {
                    return Box.DisplayType.RUN_IN;
                }
                case TABLE: {
                    return Box.DisplayType.TABLE;
                }
                case TABLE_CAPTION: {
                    return Box.DisplayType.TABLE_CAPTION;
                }
                case TABLE_CELL: {
                    return Box.DisplayType.TABLE_CELL;
                }
                case TABLE_COLUMN: {
                    return Box.DisplayType.TABLE_COLUMN;
                }
                case TABLE_COLUMN_GROUP: {
                    return Box.DisplayType.TABLE_COLUMN_GROUP;
                }
                case TABLE_FOOTER_GROUP: {
                    return Box.DisplayType.TABLE_FOOTER_GROUP;
                }
                case TABLE_HEADER_GROUP: {
                    return Box.DisplayType.TABLE_HEADER_GROUP;
                }
                case TABLE_ROW: {
                    return Box.DisplayType.TABLE_ROW;
                }
                case TABLE_ROW_GROUP: {
                    return Box.DisplayType.TABLE_ROW_GROUP;
                }
            }
            return Box.DisplayType.BLOCK;
        }
        return null;
    }

    public Rectangular getSubstringBounds(int startPos, int endPos) {
        org.fit.cssbox.layout.Box box = this.getBox();
        if (box instanceof TextBox) {
            Rectangular ret = new Rectangular(this.getVisualBounds());
            int origin = ret.getX1();
            int startOfs = this.zoom(((TextBox)box).getCharOffsetX(startPos));
            int endOfs = this.zoom(((TextBox)box).getCharOffsetX(endPos));
            ret.setX1(origin + startOfs);
            ret.setX2(origin + endOfs);
            return ret;
        }
        return null;
    }

    private int zoom(float src) {
        return Math.round(src * this.zoom);
    }
}

