/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.layout.cssbox.impl;

import cz.vutbr.fit.layout.cssbox.impl.Units;
import cz.vutbr.fit.layout.model.Rectangular;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import org.fit.cssbox.awt.Transform;
import org.fit.cssbox.layout.Box;
import org.fit.cssbox.layout.ElementBox;

public class BoxTransform {
    private Box box;
    private AffineTransform transform;

    public BoxTransform(Box box) {
        this.box = box;
        this.transform = box instanceof ElementBox ? this.createTransform((ElementBox)box) : null;
    }

    public BoxTransform(BoxTransform src) {
        this.box = src.box;
        this.transform = src.transform;
    }

    public Box getBox() {
        return this.box;
    }

    public AffineTransform getTransform() {
        return this.transform;
    }

    public boolean isEmpty() {
        return this.transform == null;
    }

    public BoxTransform concatenate(BoxTransform src) {
        if (src.isEmpty()) {
            return this;
        }
        if (this.isEmpty()) {
            return src;
        }
        BoxTransform ret = new BoxTransform(this);
        ret.transform = new AffineTransform(this.transform);
        ret.transform.concatenate(src.transform);
        return ret;
    }

    public Rectangular transformRect(Rectangular rect) {
        if (this.transform != null) {
            Rectangle src = new Rectangle(rect.getX1(), rect.getY1(), rect.getWidth(), rect.getHeight());
            Shape dest = this.transform.createTransformedShape(src);
            Rectangle destr = dest instanceof Rectangle ? (Rectangle)dest : dest.getBounds();
            return Units.toRectangular(destr);
        }
        return rect;
    }

    protected AffineTransform createTransform(ElementBox elem) {
        return Transform.createTransform((ElementBox)elem);
    }
}

