/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.layout.cssbox.impl;

import cz.vutbr.fit.layout.cssbox.impl.BoxNode;
import cz.vutbr.fit.layout.cssbox.impl.Units;
import cz.vutbr.fit.layout.model.Color;
import cz.vutbr.fit.layout.model.Page;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.fit.cssbox.awt.Transform;
import org.fit.cssbox.css.BackgroundDecoder;
import org.fit.cssbox.layout.Box;
import org.fit.cssbox.layout.ElementBox;
import org.fit.cssbox.layout.ListItemBox;
import org.fit.cssbox.layout.ReplacedBox;
import org.fit.cssbox.layout.TextBox;
import org.fit.cssbox.layout.Viewport;
import org.fit.cssbox.render.StructuredRenderer;

public class BoxListRenderer
extends StructuredRenderer {
    private Page page;
    private float zoom;
    private List<cz.vutbr.fit.layout.model.Box> boxList;
    private AffineTransform currentTransform;
    private Map<ElementBox, AffineTransform> savedTransforms;
    private int orderCounter;

    public BoxListRenderer(Page page, float zoom) {
        this.page = page;
        this.zoom = zoom;
        this.boxList = new ArrayList<cz.vutbr.fit.layout.model.Box>();
        this.savedTransforms = new HashMap<ElementBox, AffineTransform>();
        this.orderCounter = 0;
    }

    public List<cz.vutbr.fit.layout.model.Box> getBoxList() {
        return this.boxList;
    }

    public void setBoxList(List<cz.vutbr.fit.layout.model.Box> boxList) {
        this.boxList = boxList;
    }

    public void startElementContents(ElementBox elem) {
        AffineTransform at = Transform.createTransform((ElementBox)elem);
        if (at != null) {
            this.savedTransforms.put(elem, this.currentTransform);
            this.currentTransform = at;
        }
    }

    public void finishElementContents(ElementBox elem) {
        AffineTransform origAt;
        this.currentTransform = origAt = this.savedTransforms.get(elem);
    }

    public void renderElementBackground(ElementBox elem) {
        BoxNode newnode;
        Color bgColor;
        BackgroundDecoder bg = this.findBackgroundSource(elem);
        Color color = bgColor = bg == null ? null : Units.toColor(bg.getBgcolor());
        if (bgColor == null && elem instanceof Viewport) {
            bgColor = Color.WHITE;
        }
        if ((newnode = new BoxNode((Box)elem, this.page, bgColor, this.zoom)).isVisible()) {
            newnode.setOrder(this.orderCounter++);
            newnode.setId(newnode.getOrder());
            this.boxList.add((cz.vutbr.fit.layout.model.Box)newnode);
        }
    }

    public void renderMarker(ListItemBox elem) {
    }

    public void renderTextContent(TextBox text) {
        BoxNode newnode = new BoxNode((Box)text, this.page, this.zoom);
        if (newnode.isVisible()) {
            newnode.setOrder(this.orderCounter++);
            newnode.setId(newnode.getOrder());
            this.boxList.add((cz.vutbr.fit.layout.model.Box)newnode);
        }
    }

    public void renderReplacedContent(ReplacedBox box) {
    }

    public void close() throws IOException {
    }
}

