/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.layout.json.impl;

import com.google.gson.Gson;
import cz.vutbr.fit.layout.impl.BaseBoxTreeBuilder;
import cz.vutbr.fit.layout.json.impl.BoxList;
import cz.vutbr.fit.layout.json.impl.PageImpl;
import cz.vutbr.fit.layout.json.parser.InputFile;
import cz.vutbr.fit.layout.json.parser.MetadataDef;
import cz.vutbr.fit.layout.json.parser.PageInfo;
import cz.vutbr.fit.layout.model.Box;
import cz.vutbr.fit.layout.model.Color;
import cz.vutbr.fit.layout.model.Page;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JSONBoxTreeBuilder
extends BaseBoxTreeBuilder {
    private static Logger log = LoggerFactory.getLogger(JSONBoxTreeBuilder.class);
    public static final String DEFAULT_FONT_FAMILY = "sans-serif";
    public static final float DEFAULT_FONT_SIZE = 12.0f;
    private InputFile inputFile;
    private PageImpl page;

    public JSONBoxTreeBuilder(boolean useVisualBounds, boolean preserveAux) {
        super(useVisualBounds, preserveAux);
    }

    public void parse(String urlstring) throws MalformedURLException, IOException, InterruptedException {
        if ((urlstring = urlstring.trim()).startsWith("http:") || urlstring.startsWith("https:") || urlstring.startsWith("ftp:") || urlstring.startsWith("file:")) {
            this.parse(new URL(urlstring));
        } else if (urlstring.startsWith("json:")) {
            this.parseJSON(urlstring.substring(5));
        } else {
            throw new MalformedURLException("Unsupported protocol in " + urlstring);
        }
    }

    public void parse(URL url) throws IOException, InterruptedException {
        this.inputFile = this.invokeRenderer(url);
        if (this.inputFile != null && this.inputFile.getError() == null) {
            if (this.inputFile.getStatus() != 0 && (this.inputFile.getStatus() < 200 || this.inputFile.getStatus() >= 300)) {
                throw new IOException("HTTP status: " + this.inputFile.getStatus() + " " + this.inputFile.getStatusText());
            }
        } else {
            if (this.inputFile.getError() != null) {
                throw new IOException(this.inputFile.getError());
            }
            throw new IOException("Backend execution failed");
        }
        this.parseInputFile(this.inputFile, url);
    }

    public void parseJSON(String path) throws IOException {
        URL url;
        this.inputFile = this.loadJSON(path);
        try {
            url = this.inputFile.page != null && this.inputFile.page.url != null ? new URL(this.inputFile.page.url) : new URL("http://url.not.available");
        }
        catch (MalformedURLException e) {
            url = new URL("http://url.not.available");
        }
        this.parseInputFile(this.inputFile, url);
    }

    protected void parseInputFile(InputFile input, URL url) throws IOException {
        this.inputFile = input;
        PageInfo pInfo = this.inputFile.getPage();
        this.page = new PageImpl(url);
        this.page.setTitle(pInfo.getTitle());
        this.page.setWidth(Math.round(pInfo.getWidth()));
        this.page.setHeight(Math.round(pInfo.getHeight()));
        if (input.getScreenshot() != null) {
            try {
                byte[] image = Base64.getDecoder().decode(input.getScreenshot());
                this.page.setPngImage(image);
            }
            catch (IllegalArgumentException e) {
                log.error("Couldn't decode a base64 screenshot: {}", (Object)e.getMessage());
            }
        }
        BoxList boxlist = new BoxList(this.inputFile, (Page)this.page);
        Box root = this.buildTree(boxlist.getVisibleBoxes(), Color.WHITE);
        this.page.setRoot(root);
        if (input.getMetadata() != null) {
            ArrayList<MetadataDef> data = new ArrayList<MetadataDef>();
            for (MetadataDef item : input.getMetadata()) {
                data.add(item);
            }
            this.page.setMetadata(data);
        }
    }

    public Page getPage() {
        return this.page;
    }

    protected abstract InputFile invokeRenderer(URL var1) throws IOException, InterruptedException;

    protected InputFile loadJSON(String path) throws IOException {
        FileReader fin = new FileReader(path);
        Gson gson = new Gson();
        InputFile file = (InputFile)gson.fromJson((Reader)fin, InputFile.class);
        fin.close();
        return file;
    }

    protected InputFile loadJSON(InputStream istream, String charsetName) throws IOException {
        InputStreamReader fin = new InputStreamReader(istream, charsetName);
        Gson gson = new Gson();
        InputFile file = (InputFile)gson.fromJson((Reader)fin, InputFile.class);
        ((Reader)fin).close();
        return file;
    }
}

