/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.layout.pdf;

import cz.vutbr.fit.layout.api.Parameter;
import cz.vutbr.fit.layout.api.ServiceException;
import cz.vutbr.fit.layout.impl.BaseArtifactService;
import cz.vutbr.fit.layout.impl.ParameterBoolean;
import cz.vutbr.fit.layout.impl.ParameterFloat;
import cz.vutbr.fit.layout.impl.ParameterInt;
import cz.vutbr.fit.layout.impl.ParameterString;
import cz.vutbr.fit.layout.model.Artifact;
import cz.vutbr.fit.layout.model.Page;
import cz.vutbr.fit.layout.ontology.BOX;
import cz.vutbr.fit.layout.pdf.impl.PDFBoxTreeBuilder;
import cz.vutbr.fit.layout.pdf.impl.PageImpl;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.rdf4j.model.IRI;
import org.xml.sax.SAXException;

public class PDFBoxTreeProvider
extends BaseArtifactService {
    private String urlstring;
    private boolean acquireImages;
    private boolean includeScreenshot;
    private float zoom;
    private int startPage;
    private int endPage;
    private PDFBoxTreeBuilder builder;

    public PDFBoxTreeProvider() {
        this.urlstring = null;
        this.acquireImages = false;
        this.includeScreenshot = true;
        this.zoom = 1.0f;
        this.startPage = 0;
        this.endPage = 10;
    }

    public PDFBoxTreeProvider(URL url) {
        this();
        this.urlstring = url.toString();
    }

    public PDFBoxTreeProvider(URL url, boolean acquireImages, boolean includeScreenshot, float zoom, int startPage, int endPage) {
        this.urlstring = url.toString();
        this.acquireImages = acquireImages;
        this.includeScreenshot = includeScreenshot;
        this.zoom = zoom;
        this.startPage = startPage;
        this.endPage = endPage;
    }

    public String getId() {
        return "FitLayout.PDF";
    }

    public String getName() {
        return "PDF document renderer";
    }

    public String getDescription() {
        return "Renders PDF documents";
    }

    public List<Parameter> defineParams() {
        ArrayList<Parameter> ret = new ArrayList<Parameter>(6);
        ret.add((Parameter)new ParameterString("url", "The URL of the document to render", 0, 64));
        ret.add((Parameter)new ParameterBoolean("acquireImages", "Include the images in the rendered page model?"));
        ret.add((Parameter)new ParameterBoolean("includeScreenshot", "Include the screen shot of the entire page in the rendered page model?"));
        ret.add((Parameter)new ParameterFloat("zoom", "Zoom factor to be applied on the rendered page", -5.0f, 10.0f));
        ret.add((Parameter)new ParameterInt("startPage", "The first page to be rendered (starting with 0)", 0, 1000));
        ret.add((Parameter)new ParameterInt("endPage", "The last page to be rendered", 0, 1000));
        return ret;
    }

    public String getUrl() {
        return this.urlstring;
    }

    public void setUrl(String url) {
        this.urlstring = new String(url);
    }

    public boolean getAcquireImages() {
        return this.acquireImages;
    }

    public void setAcquireImages(boolean acquireImages) {
        this.acquireImages = acquireImages;
    }

    public boolean getIncludeScreenshot() {
        return this.includeScreenshot;
    }

    public void setIncludeScreenshot(boolean includeScreenshot) {
        this.includeScreenshot = includeScreenshot;
    }

    public int getStartPage() {
        return this.startPage;
    }

    public void setStartPage(int startPage) {
        this.startPage = startPage;
    }

    public int getEndPage() {
        return this.endPage;
    }

    public void setEndPage(int endPage) {
        this.endPage = endPage;
    }

    public float getZoom() {
        return this.zoom;
    }

    public void setZoom(float zoom) {
        this.zoom = zoom;
    }

    public IRI getConsumes() {
        return null;
    }

    public IRI getProduces() {
        return BOX.Page;
    }

    public Artifact process(Artifact input) throws ServiceException {
        if (this.urlstring == null || this.urlstring.isBlank()) {
            throw new ServiceException("No URL provided");
        }
        try {
            Page page = this.getPage();
            IRI pageIri = this.getServiceManager().getArtifactRepository().createArtifactIri((Artifact)page);
            page.setIri(pageIri);
            return page;
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public Page getPage() throws IOException, SAXException {
        this.builder = new PDFBoxTreeBuilder(false, true);
        this.builder.setAcquireImages(this.acquireImages);
        this.builder.setIncludeScreenshot(this.includeScreenshot);
        this.builder.setStartPage(this.startPage);
        this.builder.setEndPage(this.endPage);
        this.builder.setZoom(this.zoom);
        this.builder.parse(this.urlstring);
        PageImpl page = (PageImpl)this.builder.getPage();
        page.setCreator(this.getId());
        page.setCreatorParams(this.getParamString());
        return page;
    }
}

