/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.layout.pdf.impl;

import cz.vutbr.fit.layout.impl.DefaultContentImage;
import cz.vutbr.fit.layout.model.Border;
import cz.vutbr.fit.layout.model.Box;
import cz.vutbr.fit.layout.model.Color;
import cz.vutbr.fit.layout.model.ContentObject;
import cz.vutbr.fit.layout.model.GenericTreeNode;
import cz.vutbr.fit.layout.model.Rectangular;
import cz.vutbr.fit.layout.model.TextStyle;
import cz.vutbr.fit.layout.pdf.impl.BoxImpl;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.graphics.color.PDColor;
import org.fit.pdfdom.HtmlDivLine;
import org.fit.pdfdom.PDFBoxTree;
import org.fit.pdfdom.PathSegment;
import org.fit.pdfdom.TextMetrics;
import org.fit.pdfdom.resource.ImageResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FLBoxTree
extends PDFBoxTree {
    private static Logger log = LoggerFactory.getLogger(FLBoxTree.class);
    private static final Color DOCUMENT_COLOR = new Color(238, 238, 238);
    private static final Color PAGE_COLOR = Color.WHITE;
    private static final int PAGE_GAP = 10;
    private boolean acquireImages = true;
    private float zoom = 1.0f;
    private List<Box> allBoxes = new ArrayList<Box>();
    private BoxImpl root;
    private BoxImpl pageBox;
    private List<Integer> pageYOffsets = new ArrayList<Integer>();
    private int curPageY = 0;
    private int nextPageY = 0;
    private int maxPageWidth = 0;
    private int orderCounter = 0;

    public boolean isAcquireImages() {
        return this.acquireImages;
    }

    public void setAcquireImages(boolean acquireImages) {
        this.acquireImages = acquireImages;
    }

    public float getZoom() {
        return this.zoom;
    }

    public void setZoom(float zoom) {
        this.zoom = zoom;
    }

    public List<Box> getAllBoxes() {
        return this.allBoxes;
    }

    public BoxImpl getRoot() {
        return this.root;
    }

    public List<Integer> getPageYOffsets() {
        return this.pageYOffsets;
    }

    public void processDocument(PDDocument pdfdocument, int startPage, int endPage) throws IOException {
        this.setStartPage(startPage);
        this.setEndPage(endPage);
        this.processPDF(pdfdocument);
    }

    protected void processPDF(PDDocument doc) throws IOException {
        super.writeText(doc, (Writer)new OutputStreamWriter(System.out));
    }

    protected void addBox(BoxImpl parent, BoxImpl newBox) {
        this.allBoxes.add((Box)newBox);
        if (parent != null) {
            parent.appendChild((GenericTreeNode)newBox);
            newBox.setIntrinsicParent((Box)parent);
        }
    }

    protected void startDocument(PDDocument document) throws IOException {
        this.root = this.createBox(0, 0, 100, 100);
        this.root.setTagName("#document");
        this.root.setBackgroundColor(DOCUMENT_COLOR);
        this.addBox(null, this.root);
    }

    protected void endDocument(PDDocument document) throws IOException {
        this.root.setBounds(new Rectangular(0, 0, this.maxPageWidth - 1, this.nextPageY - 1));
        this.root.setContentBounds(new Rectangular(this.root.getBounds()));
    }

    protected void startNewPage() {
        PDRectangle layout = this.getCurrentMediaBox();
        if (layout != null) {
            int w = this.convertLengthI(layout.getWidth());
            int h = this.convertLengthI(layout.getHeight());
            int rot = this.pdpage.getRotation();
            if (rot == 90 || rot == 270) {
                int x = w;
                w = h;
                h = x;
            }
            this.curPageY = this.nextPageY;
            this.pageYOffsets.add(this.curPageY);
            this.pageBox = this.createBox(0, this.curPageY, w, h);
            this.pageBox.setTagName("page");
            this.pageBox.setBackgroundColor(PAGE_COLOR);
            this.nextPageY += h + 10;
            this.maxPageWidth = Math.max(this.maxPageWidth, w);
            this.addBox(this.root, this.pageBox);
        } else {
            log.warn("No media box found");
        }
    }

    protected void renderText(String data, TextMetrics metrics) {
        BoxImpl textBox = this.createBox(this.convertLengthI(this.curstyle.getLeft()), this.curPageY + this.convertLengthI(this.curstyle.getTop()), this.convertLengthI(metrics.getWidth()), this.convertLengthI(metrics.getHeight()));
        textBox.setType(Box.Type.TEXT_CONTENT);
        textBox.setOwnText(data);
        textBox.setFontFamily(this.curstyle.getFontFamily());
        textBox.setTextStyle(this.getCurrentTextStyle(data.length()));
        textBox.setColor(this.parseColor(this.curstyle.getColor()));
        this.addBox(this.pageBox, textBox);
    }

    protected void renderPath(List<PathSegment> path, boolean stroke, boolean fill) throws IOException {
        float[] rect = this.toRectangle(path);
        if (rect != null) {
            BoxImpl rectBox = this.createRectangleBox(rect[0], rect[1], rect[2] - rect[0], rect[3] - rect[1], this.curPageY, stroke, fill);
            this.addBox(this.pageBox, rectBox);
        } else if (stroke) {
            for (PathSegment segm : path) {
                BoxImpl lineBox = this.createLineBox(segm.getX1(), segm.getY1(), segm.getX2(), segm.getY2(), this.curPageY);
                this.addBox(this.pageBox, lineBox);
            }
        }
    }

    protected void renderImage(float x, float y, float width, float height, ImageResource data) throws IOException {
        BoxImpl imageBox = this.createImageBox(x, y, width, height, this.curPageY, data);
        this.addBox(this.pageBox, imageBox);
    }

    protected BoxImpl createBox() {
        BoxImpl ret = new BoxImpl();
        return ret;
    }

    protected BoxImpl createBox(int x, int y, int w, int h) {
        BoxImpl ret = this.createBox();
        ret.setOrder(this.orderCounter++);
        ret.setId(ret.getOrder());
        ret.setSourceNodeId("b" + ret.getOrder());
        ret.setBounds(new Rectangular(x, y, x + w - 1, y + h - 1, false));
        ret.setContentBounds(new Rectangular(ret.getBounds()));
        return ret;
    }

    protected BoxImpl createRectangleBox(float x, float y, float width, float height, int pageOffset, boolean stroke, boolean fill) {
        Color clr;
        float lineWidth = this.transformWidth(this.getGraphicsState().getLineWidth());
        float wcor = stroke ? lineWidth : 0.0f;
        float strokeOffset = wcor / 2.0f;
        float w = width + wcor;
        float h = height + wcor;
        int dx = this.convertLengthI(x - strokeOffset);
        int dy = this.convertLengthI(y - strokeOffset) + pageOffset;
        int dw = this.convertLengthI(w);
        int dh = this.convertLengthI(h);
        BoxImpl ret = this.createBox(dx, dy, dw, dh);
        ret.setTagName("rect");
        ret.setType(Box.Type.ELEMENT);
        if (stroke) {
            clr = this.convertColor(this.getGraphicsState().getStrokingColor());
            Border b = new Border(this.convertLengthI(lineWidth), Border.Style.SOLID, clr);
            for (Border.Side side : Border.Side.values()) {
                ret.setBorderStyle(side, b);
            }
        }
        if (fill) {
            clr = this.convertColor(this.getGraphicsState().getNonStrokingColor());
            ret.setBackgroundColor(clr);
        }
        return ret;
    }

    protected BoxImpl createLineBox(float x1, float y1, float x2, float y2, int pageOffset) {
        HtmlDivLine line = new HtmlDivLine(x1, y1, x2, y2, this.transformWidth(this.getGraphicsState().getLineWidth()));
        Color color = this.convertColor(this.getGraphicsState().getStrokingColor());
        BoxImpl ret = this.createBox(this.convertLengthI(line.getLeft()), this.convertLengthI(line.getTop()) + pageOffset, this.convertLengthI(line.getWidth()), this.convertLengthI(line.getHeight()));
        ret.setTagName("line");
        ret.setType(Box.Type.ELEMENT);
        Border.Side side = line.isVertical() ? Border.Side.RIGHT : Border.Side.BOTTOM;
        ret.setBorderStyle(side, new Border(this.convertLengthI(line.getLineStrokeWidth()), Border.Style.SOLID, color));
        return ret;
    }

    protected BoxImpl createImageBox(float x, float y, float width, float height, int pageOffset, ImageResource resource) throws IOException {
        BoxImpl ret = this.createBox(this.convertLengthI(x), this.convertLengthI(y) + pageOffset, this.convertLengthI(width), this.convertLengthI(height));
        ret.setTagName("img");
        ret.setType(Box.Type.REPLACED_CONTENT);
        if (this.isAcquireImages() && resource.getData() != null) {
            try {
                DefaultContentImage img = new DefaultContentImage();
                byte[] scaled = this.scaleImageData(resource.getData(), this.convertLengthI(width), this.convertLengthI(height));
                img.setPngData(scaled);
                ret.setContentObject((ContentObject)img);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return ret;
    }

    protected float convertLength(float length) {
        return length * 1.3333334f * this.zoom;
    }

    protected int convertLengthI(float length) {
        int ret = Math.round(this.convertLength(length));
        if (ret == 0 && length > 0.1f) {
            ret = 1;
        }
        return ret;
    }

    protected TextStyle getCurrentTextStyle(int contentLength) {
        TextStyle ret = new TextStyle();
        ret.setContentLength(contentLength);
        ret.setFontSizeSum(this.convertLength(this.curstyle.getFontSize()) * (float)contentLength);
        ret.setFontWeightSum((float)(this.styleValue(this.curstyle.getFontWeight(), "bold") * contentLength));
        ret.setFontStyleSum((float)(this.styleValue(this.curstyle.getFontStyle(), "italic") * contentLength));
        return ret;
    }

    protected int styleValue(String val, String oneval) {
        return oneval.equals(val) ? 1 : 0;
    }

    protected Color parseColor(String hash) {
        if (hash.length() == 4) {
            String r = hash.substring(1, 2);
            String g = hash.substring(2, 3);
            String b = hash.substring(3, 4);
            return new Color(Integer.parseInt(r + r, 16), Integer.parseInt(g + g, 16), Integer.parseInt(b + b, 16));
        }
        if (hash.length() == 7) {
            String r = hash.substring(1, 3);
            String g = hash.substring(3, 5);
            String b = hash.substring(5, 7);
            return new Color(Integer.parseInt(r, 16), Integer.parseInt(g, 16), Integer.parseInt(b, 16));
        }
        return Color.BLACK;
    }

    protected Color convertColor(PDColor pdcolor) {
        Color color = null;
        try {
            float[] rgb = pdcolor.getColorSpace().toRGB(pdcolor.getComponents());
            color = new Color(Math.round(rgb[0] * 255.0f), Math.round(rgb[1] * 255.0f), Math.round(rgb[2] * 255.0f));
        }
        catch (IOException e) {
            log.error("convertColor: IOException: {}", (Object)e.getMessage());
        }
        catch (UnsupportedOperationException e) {
            log.error("convertColor: UnsupportedOperationException: {}", (Object)e.getMessage());
        }
        return color;
    }

    public byte[] scaleImageData(byte[] srcData, int destWidth, int destHeight) throws IOException {
        ByteArrayInputStream is = new ByteArrayInputStream(srcData);
        BufferedImage srcImage = ImageIO.read(is);
        BufferedImage scaledImage = FLBoxTree.scaleImage(srcImage, destWidth, destHeight);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)scaledImage, "png", os);
        return os.toByteArray();
    }

    public static BufferedImage scaleImage(BufferedImage source, int destWidth, int destHeight) {
        BufferedImage copy = new BufferedImage(destWidth, destHeight, 2);
        Graphics gfx = copy.getGraphics();
        gfx.drawImage(source, 0, 0, destWidth, destHeight, null);
        gfx.dispose();
        return copy;
    }
}

