/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.layout.pdf.impl;

import cz.vutbr.fit.layout.impl.BaseBoxTreeBuilder;
import cz.vutbr.fit.layout.model.Box;
import cz.vutbr.fit.layout.model.Color;
import cz.vutbr.fit.layout.model.Page;
import cz.vutbr.fit.layout.pdf.impl.FLBoxTree;
import cz.vutbr.fit.layout.pdf.impl.PageImpl;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import javax.imageio.ImageIO;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.rendering.PDFRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class PDFBoxTreeBuilder
extends BaseBoxTreeBuilder {
    private static Logger log = LoggerFactory.getLogger(PDFBoxTreeBuilder.class);
    private static String USER_AGENT = "Mozilla/5.0 (compatible; FitLayout/2.x; Linux) PDFRenderer/2.x (like Gecko)";
    private PageImpl page;
    private boolean acquireImages;
    private boolean includeScreenshot;
    private float zoom = 1.0f;
    private int startPage = 0;
    private int endPage = 1000;

    public PDFBoxTreeBuilder(boolean useVisualBounds, boolean preserveAux) {
        super(useVisualBounds, preserveAux);
    }

    public boolean getAcquireImages() {
        return this.acquireImages;
    }

    public void setAcquireImages(boolean acquireImages) {
        this.acquireImages = acquireImages;
    }

    public boolean getIncludeScreenshot() {
        return this.includeScreenshot;
    }

    public void setIncludeScreenshot(boolean includeScreenshot) {
        this.includeScreenshot = includeScreenshot;
    }

    public float getZoom() {
        return this.zoom;
    }

    public void setZoom(float zoom) {
        this.zoom = zoom;
    }

    public int getStartPage() {
        return this.startPage;
    }

    public void setStartPage(int startPage) {
        this.startPage = startPage;
    }

    public int getEndPage() {
        return this.endPage;
    }

    public void setEndPage(int endPage) {
        this.endPage = endPage;
    }

    public Page getPage() {
        return this.page;
    }

    public void parse(String urlstring) throws MalformedURLException, IOException, SAXException {
        this.parse(new URL(urlstring.trim()));
    }

    public void parse(URL url) throws IOException, SAXException {
        PDDocument doc = this.loadPdf(url);
        FLBoxTree boxTree = this.createBoxTree(doc);
        List<Box> boxlist = boxTree.getAllBoxes();
        Color bg = Color.WHITE;
        Box root = this.buildTree(boxlist, bg);
        String pageTitle = doc.getDocumentInformation().getTitle();
        if (pageTitle == null) {
            pageTitle = "";
        }
        PageImpl pg = this.page = new PageImpl(this.pageUrl);
        pg.setTitle(pageTitle);
        pg.setRoot(root);
        pg.setWidth(root.getWidth());
        pg.setHeight(root.getHeight());
        if (this.includeScreenshot) {
            pg.setPngImage(this.createScreenShot(doc, root.getWidth(), root.getHeight(), boxTree.getPageYOffsets()));
        }
        doc.close();
    }

    private FLBoxTree createBoxTree(PDDocument doc) throws IOException {
        FLBoxTree boxTree = new FLBoxTree();
        boxTree.setAcquireImages(this.acquireImages);
        boxTree.setZoom(this.getZoom());
        boxTree.processDocument(doc, this.getStartPage(), this.getEndPage());
        return boxTree;
    }

    private PDDocument loadPdf(URL url) throws IOException {
        int p;
        URLConnection con = url.openConnection();
        con.setRequestProperty("User-Agent", USER_AGENT);
        this.pageUrl = con.getURL();
        InputStream is = con.getInputStream();
        String mime = con.getHeaderField("Content-Type");
        if (mime == null) {
            mime = "application/pdf";
        }
        if ((p = mime.indexOf(59)) != -1) {
            mime = mime.substring(0, p).trim();
        }
        log.info("File type: " + mime);
        if (mime.equals("application/pdf")) {
            return this.loadPdf(is);
        }
        throw new IOException("Unsupported MIME type " + mime);
    }

    private PDDocument loadPdf(InputStream is) throws IOException {
        PDDocument document = null;
        document = PDDocument.load((InputStream)is);
        return document;
    }

    private byte[] createScreenShot(PDDocument doc, int width, int height, List<Integer> pageYOffsets) throws IOException {
        PDFRenderer renderer = new PDFRenderer(doc);
        BufferedImage img = new BufferedImage(width, height, 1);
        Graphics gfx = img.getGraphics();
        int curPage = this.startPage;
        for (Integer ofs : pageYOffsets) {
            BufferedImage pageImg = renderer.renderImageWithDPI(curPage, 96.0f * this.zoom);
            gfx.drawImage(pageImg, 0, ofs, null);
            ++curPage;
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)img, "png", os);
        return os.toByteArray();
    }
}

