/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.layout.playwright;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import cz.vutbr.fit.layout.playwright.impl.BrowserControl;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Map;
import picocli.CommandLine;

@CommandLine.Command(name="BrowserControl", mixinStandardHelpOptions=true, sortOptions=false, abbreviateSynopsis=true)
public class BrowserCli
implements Runnable {
    @CommandLine.Option(order=1, names={"-W", "--width"}, paramLabel="width", description={"Target page width"})
    protected int width = 1200;
    @CommandLine.Option(order=2, names={"-H", "--height"}, paramLabel="height", description={"Target page height"})
    protected int height = 800;
    @CommandLine.Option(order=3, names={"-P", "--persistence"}, paramLabel="value", description={"Content downloading persistence: 0 (quick), 1 (standard), 2 (wait longer), 3 (get as much as possible)"})
    protected int persistence = 1;
    @CommandLine.Option(order=4, names={"-s", "--screenshot"}, paramLabel="value", description={"Include a screenshot in the result"})
    protected boolean screenshot = false;
    @CommandLine.Option(order=5, names={"-I", "--download-images"}, paramLabel="value", description={"Download all contained images referenced in <img> elements"})
    protected boolean downloadImages = false;
    @CommandLine.Option(order=6, names={"-N", "--no-headless"}, paramLabel="value", description={"Do not use headless mode; show the browser in foreground"})
    protected boolean noHeadless = false;
    @CommandLine.Option(order=7, names={"-C", "--no-close"}, paramLabel="value", description={"Do not close the browser after the operation"})
    protected boolean noClose = false;
    @CommandLine.Option(order=8, names={"-d", "--user-dir"}, paramLabel="value", description={"Browser profile directory to be used (default location is used when not specified)"})
    protected String userDir = "";
    @CommandLine.Parameters(arity="1", index="0", paramLabel="url", description={"The URL to visit"})
    protected String url;

    @Override
    public void run() {
        try (BrowserControl bc = new BrowserControl();){
            bc.setWidth(this.width);
            bc.setHeight(this.height);
            bc.setNoHeadless(this.noHeadless);
            bc.setPersist(this.persistence);
            bc.setIncludeScreenshot(this.screenshot);
            bc.setAcquireImages(this.downloadImages);
            bc.setUserDir(this.userDir);
            Map<String, Object> pg = bc.visit(this.url);
            Gson gson = new Gson();
            JsonElement jsonPage = gson.toJsonTree(pg);
            System.out.println(gson.toJson(jsonPage));
            if (this.noClose) {
                try {
                    System.err.println("Press enter to quit");
                    BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
                    br.readLine();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    public static void main(String[] args) {
        int exitCode = new CommandLine((Object)new BrowserCli()).execute(args);
        System.exit(exitCode);
    }
}

