/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.layout.playwright.impl;

import com.microsoft.playwright.Browser;
import com.microsoft.playwright.BrowserContext;
import com.microsoft.playwright.BrowserType;
import com.microsoft.playwright.Locator;
import com.microsoft.playwright.Page;
import com.microsoft.playwright.Playwright;
import com.microsoft.playwright.Response;
import com.microsoft.playwright.options.ScreenshotType;
import com.microsoft.playwright.options.WaitUntilState;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.Scanner;

public class BrowserControl
implements AutoCloseable {
    private static final String[] clientScriptFiles = new String[]{"/chromium/jfont-checker.js", "/chromium/fonts.js", "/chromium/lines.js", "/chromium/jsonld.js", "/chromium/export.js"};
    private int width = 1200;
    private int height = 800;
    private int persist = 1;
    private boolean acquireImages = false;
    private boolean includeScreenshot = false;
    private boolean noHeadless = false;
    private String userDir = null;
    private Playwright playwright = Playwright.create();
    private Browser currentBrowser;
    private BrowserContext currentContext;

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getPersist() {
        return this.persist;
    }

    public void setPersist(int persist) {
        this.persist = persist;
    }

    public boolean isAcquireImages() {
        return this.acquireImages;
    }

    public void setAcquireImages(boolean acquireImages) {
        this.acquireImages = acquireImages;
    }

    public boolean isIncludeScreenshot() {
        return this.includeScreenshot;
    }

    public void setIncludeScreenshot(boolean includeScreenshot) {
        this.includeScreenshot = includeScreenshot;
    }

    public boolean isNoHeadless() {
        return this.noHeadless;
    }

    public void setNoHeadless(boolean noHeadless) {
        this.noHeadless = noHeadless;
    }

    public String getUserDir() {
        return this.userDir;
    }

    public void setUserDir(String userDir) {
        this.userDir = userDir;
    }

    public Map<String, Object> visit(String urlstring) {
        String scrollFn;
        Object computedTotalHeight;
        Page.NavigateOptions waitOptions;
        String lastError = null;
        this.initCurrentContext();
        int scrollPages = 20;
        switch (this.persist) {
            case 0: {
                waitOptions = new Page.NavigateOptions().setWaitUntil(WaitUntilState.DOMCONTENTLOADED).setTimeout(10000.0);
                scrollPages = 0;
                break;
            }
            case 1: {
                waitOptions = new Page.NavigateOptions().setWaitUntil(WaitUntilState.LOAD).setTimeout(15000.0);
                scrollPages = 5;
                break;
            }
            case 2: {
                waitOptions = new Page.NavigateOptions().setWaitUntil(WaitUntilState.NETWORKIDLE).setTimeout(15000.0);
                break;
            }
            default: {
                waitOptions = new Page.NavigateOptions().setWaitUntil(WaitUntilState.NETWORKIDLE).setTimeout(50000.0);
            }
        }
        Page page = this.currentContext.newPage();
        Response lastResponse = null;
        try {
            lastResponse = page.navigate(urlstring, waitOptions);
        }
        catch (Exception e) {
            lastError = e.getMessage();
        }
        int totalHeight = this.getHeight() * 2;
        if (scrollPages > 0 && (computedTotalHeight = page.evaluate(scrollFn = BrowserControl.loadResource("/common/scroll.js"), (Object)scrollPages)) instanceof Integer) {
            totalHeight = (Integer)computedTotalHeight;
        }
        page.setViewportSize(this.width, Integer.valueOf(totalHeight).intValue());
        byte[] screenshot = page.screenshot(new Page.ScreenshotOptions().setFullPage(true).setType(ScreenshotType.PNG));
        String clientScript = this.getClientScript();
        String execScript = "() => { \n" + clientScript + "   fitlayoutDetectLines();   return fitlayoutExportBoxes();}";
        Map ret = (Map)page.evaluate(execScript);
        if (this.includeScreenshot) {
            ret.put("screenshot", Base64.getEncoder().encodeToString(screenshot));
        }
        Object imagesObj = ret.get("images");
        if (this.acquireImages && imagesObj != null && imagesObj instanceof List) {
            List images = (List)imagesObj;
            page.addStyleTag(new Page.AddStyleTagOptions().setContent("[data-fitlayoutbg=\"1\"] * { display: none }"));
            for (Object imgObj : images) {
                if (!(imgObj instanceof Map)) continue;
                Map img = (Map)imgObj;
                boolean bg = img.get("bg") instanceof Boolean && (Boolean)img.get("bg") != false;
                String id = String.valueOf(img.get("id"));
                String selector = "*[data-fitlayoutid=\"" + id + "\"]";
                try {
                    Locator elem = page.locator(selector);
                    if (elem == null) continue;
                    if (bg) {
                        elem.evaluate("e => { e.setAttribute('data-fitlayoutbg', '1'); }");
                    }
                    byte[] imgData = elem.screenshot(new Locator.ScreenshotOptions().setType(ScreenshotType.PNG).setTimeout(100.0));
                    img.put("data", Base64.getEncoder().encodeToString(imgData));
                    if (!bg) continue;
                    elem.evaluate("e => { e.setAttribute('data-fitlayoutbg', '0'); }");
                }
                catch (Exception e) {
                    System.err.println(img + " : " + e.getMessage());
                }
            }
        }
        if (lastResponse != null) {
            ret.put("status", lastResponse.status());
            ret.put("statusText", lastResponse.statusText());
        }
        if (lastError != null) {
            ret.put("error", lastError);
        }
        return ret;
    }

    @Override
    public void close() {
        if (this.currentContext != null) {
            this.currentContext.close();
        }
        if (this.currentBrowser != null) {
            this.currentBrowser.close();
        }
        this.playwright.close();
    }

    protected BrowserType createBrowserType() {
        return this.playwright.chromium();
    }

    protected void initCurrentContext() {
        BrowserType btype = this.createBrowserType();
        if (this.userDir == null) {
            this.currentContext = this.launchTemporary(btype);
        } else {
            Path userDirPath = Paths.get(this.userDir, new String[0]);
            this.currentContext = this.launchPersistent(btype, userDirPath);
        }
    }

    protected BrowserContext launchTemporary(BrowserType btype) {
        BrowserType.LaunchOptions opts = new BrowserType.LaunchOptions();
        opts.setHeadless(!this.noHeadless);
        opts.setSlowMo(100.0);
        opts.setChromiumSandbox(false);
        opts.setIgnoreDefaultArgs(List.of("--disable-extensions"));
        this.currentBrowser = btype.launch(opts);
        Browser.NewContextOptions copts = new Browser.NewContextOptions();
        copts.setScreenSize(this.width, this.height);
        copts.setViewportSize(this.width, this.height);
        return this.currentBrowser.newContext(copts);
    }

    protected BrowserContext launchPersistent(BrowserType btype, Path userDir) {
        BrowserType.LaunchPersistentContextOptions opts = new BrowserType.LaunchPersistentContextOptions();
        opts.setHeadless(!this.noHeadless);
        opts.setSlowMo(100.0);
        opts.setChromiumSandbox(false);
        opts.setIgnoreDefaultArgs(List.of("--disable-extensions"));
        opts.setScreenSize(this.width, this.height);
        opts.setViewportSize(this.width, this.height);
        return btype.launchPersistentContext(userDir, opts);
    }

    protected String getClientScript() {
        StringBuilder s = new StringBuilder();
        for (String name : clientScriptFiles) {
            s.append(BrowserControl.loadResource(name));
        }
        return s.toString();
    }

    protected static String loadResource(String filePath) {
        try (Scanner scanner = new Scanner(BrowserControl.class.getResourceAsStream(filePath), "UTF-8");){
            scanner.useDelimiter("\\A");
            String string = scanner.next();
            return string;
        }
    }
}

