/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.layout.playwright.impl;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import cz.vutbr.fit.layout.json.impl.JSONBoxTreeBuilder;
import cz.vutbr.fit.layout.json.parser.InputFile;
import cz.vutbr.fit.layout.playwright.impl.BrowserControl;
import java.io.IOException;
import java.net.URL;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BoxTreeBuilder
extends JSONBoxTreeBuilder {
    private static Logger log = LoggerFactory.getLogger(BoxTreeBuilder.class);
    public static final String DEFAULT_FONT_FAMILY = "sans-serif";
    public static final float DEFAULT_FONT_SIZE = 12.0f;
    private int width;
    private int height;
    private int persist;
    private boolean acquireImages;
    private boolean includeScreenshot;

    public BoxTreeBuilder(int width, int height, boolean useVisualBounds, boolean preserveAux) {
        super(useVisualBounds, preserveAux);
        this.width = width;
        this.height = height;
        this.persist = 1;
        this.acquireImages = false;
        this.includeScreenshot = true;
    }

    public void setPersist(int persist) {
        this.persist = persist;
    }

    public void setAcquireImages(boolean acquireImages) {
        this.acquireImages = acquireImages;
    }

    public void setIncludeScreenshot(boolean includeScreenshot) {
        this.includeScreenshot = includeScreenshot;
    }

    protected InputFile invokeRenderer(URL url) throws IOException, InterruptedException {
        try (BrowserControl bc = new BrowserControl();){
            InputFile file;
            bc.setNoHeadless(false);
            bc.setWidth(this.width);
            bc.setHeight(this.height);
            bc.setPersist(this.persist);
            bc.setIncludeScreenshot(this.includeScreenshot);
            bc.setAcquireImages(this.acquireImages);
            log.debug("Visit " + url.toString());
            Map<String, Object> pg = bc.visit(url.toString());
            Gson gson = new Gson();
            JsonElement jsonPage = gson.toJsonTree(pg);
            InputFile inputFile = file = (InputFile)gson.fromJson(jsonPage, InputFile.class);
            return inputFile;
        }
    }
}

