/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.layout.puppeteer.impl;

import cz.vutbr.fit.layout.impl.DefaultContentImage;
import cz.vutbr.fit.layout.model.Border;
import cz.vutbr.fit.layout.model.Box;
import cz.vutbr.fit.layout.model.Color;
import cz.vutbr.fit.layout.model.ContentObject;
import cz.vutbr.fit.layout.model.Rectangular;
import cz.vutbr.fit.layout.puppeteer.impl.BoxImpl;
import cz.vutbr.fit.layout.puppeteer.impl.CSSBorder;
import cz.vutbr.fit.layout.puppeteer.impl.CSSTextStyle;
import cz.vutbr.fit.layout.puppeteer.impl.Units;
import cz.vutbr.fit.layout.puppeteer.parser.Attribute;
import cz.vutbr.fit.layout.puppeteer.parser.BoxInfo;
import cz.vutbr.fit.layout.puppeteer.parser.ImageInfo;
import cz.vutbr.fit.layout.puppeteer.parser.InputFile;
import cz.vutbr.web.css.CSSException;
import cz.vutbr.web.css.CSSFactory;
import cz.vutbr.web.css.CSSProperty;
import cz.vutbr.web.css.Declaration;
import cz.vutbr.web.css.NodeData;
import cz.vutbr.web.css.RuleSet;
import cz.vutbr.web.css.StyleSheet;
import cz.vutbr.web.css.Term;
import cz.vutbr.web.css.TermColor;
import cz.vutbr.web.css.TermInteger;
import cz.vutbr.web.css.TermList;
import cz.vutbr.web.css.TermNumber;
import cz.vutbr.web.css.TermString;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BoxList {
    private static Logger log = LoggerFactory.getLogger(BoxList.class);
    private static final int BOX_OFFSET = 1;
    private Set<String> defaultFonts = Set.of("serif", "sans-serif", "monospace");
    private Set<String> availFonts;
    private BoxImpl viewport;
    private List<Box> boxes;

    public BoxList(InputFile inputFile) {
        this.availFonts = Set.of(inputFile.getFonts());
        this.viewport = this.createViewport(inputFile);
        this.createBoxList(inputFile);
        if (this.boxes.size() > 1) {
            this.updateViewport((BoxImpl)this.boxes.get(1));
        }
        if (inputFile.getImages() != null) {
            this.loadImages(inputFile.getImages());
        }
    }

    public List<Box> getBoxes() {
        return this.boxes;
    }

    public List<Box> getVisibleBoxes() {
        return this.boxes.stream().filter(box -> box.isVisible()).collect(Collectors.toCollection(ArrayList::new));
    }

    private BoxImpl createViewport(InputFile input) {
        BoxImpl box = new BoxImpl(this);
        box.setOrder(0);
        box.setId(0);
        box.setTagName("viewport");
        box.setSourceNodeId("viewport");
        box.setIntrinsicBounds(new Rectangular(0, 0, Math.round(input.getPage().getWidth()), Math.round(input.getPage().getHeight())));
        box.applyIntrinsicBounds();
        box.setAbsolute(true);
        box.setFontFamily("sans-serif");
        box.setColor(Color.BLACK);
        box.setBackgroundColor(Color.WHITE);
        return box;
    }

    private void updateViewport(BoxImpl body) {
        if (body.getBackgroundColor() != null) {
            this.viewport.setBackgroundColor(body.getBackgroundColor());
        }
        this.viewport.setColor(body.getColor());
    }

    private List<Box> createBoxList(InputFile input) {
        this.boxes = new ArrayList<Box>();
        this.boxes.add((Box)this.viewport);
        int nextOrder = 1;
        for (BoxInfo boxInfo : input.getBoxes()) {
            NodeData style = this.parseCss(boxInfo.getCss());
            BoxImpl newbox = boxInfo.getText() == null ? this.createElementBox(boxInfo, style, nextOrder++) : this.createTextBox(boxInfo, style, nextOrder++);
            newbox.setSourceNodeId(boxInfo.getXpath());
            if (newbox.getOffsetParent() != null) {
                newbox.applyIntrinsicBounds();
                if (!newbox.getOffsetParent().isVisible()) {
                    newbox.setVisible(false);
                }
            }
            if (newbox.getClipBox() != null) {
                Rectangular iBounds = newbox.getIntrinsicBounds();
                Rectangular clipBounds = newbox.getClipBox().getIntrinsicBounds();
                if (iBounds.isEmpty()) {
                    if (!clipBounds.contains(iBounds.getX1(), iBounds.getY1())) {
                        newbox.setVisible(false);
                    }
                } else {
                    Rectangular clipped = newbox.getIntrinsicBounds().intersection(clipBounds);
                    newbox.setBounds(clipped);
                    newbox.setContentBounds(new Rectangular(clipped));
                    if (clipped.isEmpty()) {
                        newbox.setVisible(false);
                    }
                }
            }
            this.boxes.add((Box)newbox);
            if (this.boxes.size() != 1 || newbox.getBackgroundColor() != null) continue;
            newbox.setBackgroundColor(Color.WHITE);
        }
        return this.boxes;
    }

    private BoxImpl createElementBox(BoxInfo src, NodeData style, int order) {
        Color clr;
        TermColor colorVal;
        Box.DisplayType displayType;
        CSSProperty.Display display;
        BoxImpl ret = new BoxImpl(this);
        this.setupCommonProperties(ret, src, style, order);
        this.setupParents(ret, src);
        if (src.getReplaced() != null && src.getReplaced().booleanValue()) {
            ret.setType(Box.Type.REPLACED_CONTENT);
        } else {
            ret.setType(Box.Type.ELEMENT);
        }
        ret.setTagName(src.getTagName());
        if (src.attrs != null) {
            for (Attribute attr : src.attrs) {
                ret.setAttribute(attr.getName(), attr.getValue());
            }
        }
        if ((display = (CSSProperty.Display)style.getProperty("display")) != null && (displayType = Units.toDisplayType(display)) != null) {
            ret.setDisplayType(displayType);
        }
        CSSProperty.Overflow overflowx = (CSSProperty.Overflow)style.getProperty("overflow-x");
        CSSProperty.Overflow overflowy = (CSSProperty.Overflow)style.getProperty("overflow-y");
        ret.setClipping(overflowx != null && overflowx != CSSProperty.Overflow.VISIBLE || overflowy != null && overflowy != CSSProperty.Overflow.VISIBLE);
        CSSProperty.BackgroundColor color = (CSSProperty.BackgroundColor)style.getProperty("background-color");
        if (color == CSSProperty.BackgroundColor.color && (colorVal = (TermColor)style.getValue(TermColor.class, "background-color", false)) != null && (clr = Units.toColor((cz.vutbr.web.csskit.Color)colorVal.getValue())).getAlpha() > 0) {
            ret.setBackgroundColor(clr);
        }
        for (Border.Side side : Border.Side.values()) {
            CSSBorder brd = new CSSBorder(style, side.toString());
            if (brd.getStyle() == Border.Style.NONE) continue;
            ret.setBorderStyle(side, brd);
        }
        return ret;
    }

    private BoxImpl createTextBox(BoxInfo src, NodeData style, int order) {
        BoxImpl ret = new BoxImpl(this);
        this.setupCommonProperties(ret, src, style, order);
        this.setupParents(ret, src);
        ret.setType(Box.Type.TEXT_CONTENT);
        if (src.getText() != null) {
            CSSTextStyle tstyle = new CSSTextStyle(src, style, src.getText().length());
            ret.setIntrinsicTextStyle(tstyle);
            ret.setTextStyle(tstyle);
            ret.setOwnText(src.getText());
        }
        return ret;
    }

    private void setupCommonProperties(BoxImpl box, BoxInfo boxInfo, NodeData style, int order) {
        TermColor colorVal;
        CSSProperty.Position pos;
        Term num;
        CSSProperty.Opacity opacity;
        box.setOrder(order);
        box.setId(order);
        Rectangular ibounds = new Rectangular(Math.round(boxInfo.getX()), Math.round(boxInfo.getY()), Math.round(boxInfo.getX() + boxInfo.getWidth() - 1.0f), Math.round(boxInfo.getY() + boxInfo.getHeight() - 1.0f), false);
        box.setIntrinsicBounds(ibounds);
        box.applyIntrinsicBounds();
        if (ibounds.isEmpty()) {
            if (boxInfo.getText() != null) {
                box.setVisible(false);
            } else if (!this.viewport.getIntrinsicBounds().contains(ibounds.getX1(), ibounds.getY1())) {
                box.setVisible(false);
            }
        } else if (!this.viewport.getIntrinsicBounds().intersects(ibounds)) {
            box.setVisible(false);
        }
        CSSProperty.Visibility visibility = (CSSProperty.Visibility)style.getProperty("visibility");
        if (visibility == CSSProperty.Visibility.HIDDEN || visibility == CSSProperty.Visibility.COLLAPSE) {
            box.setVisible(false);
        }
        if ((opacity = (CSSProperty.Opacity)style.getProperty("opacity")) == CSSProperty.Opacity.number && (num = style.getValue("opacity", false)) != null && (num instanceof TermInteger && ((TermInteger)num).getIntValue() == 0 || num instanceof TermNumber && ((Float)((TermNumber)num).getValue()).floatValue() < 0.01f)) {
            box.setVisible(false);
        }
        if ((pos = (CSSProperty.Position)style.getProperty("position")) == CSSProperty.Position.ABSOLUTE) {
            box.setAbsolute(true);
        } else if (pos == CSSProperty.Position.FIXED) {
            box.setFixed(true);
        }
        box.setFontFamily(this.getUsedFont(style, "sans-serif"));
        CSSProperty.Color color = (CSSProperty.Color)style.getProperty("color");
        if (color == CSSProperty.Color.color && (colorVal = (TermColor)style.getValue(TermColor.class, "color", false)) != null) {
            box.setColor(Units.toColor((cz.vutbr.web.csskit.Color)colorVal.getValue()));
        }
    }

    private void setupParents(BoxImpl box, BoxInfo boxInfo) {
        BoxImpl parent;
        int pindex;
        if (boxInfo.getParent() != null) {
            pindex = boxInfo.getParent() + 1;
            if (pindex < this.boxes.size()) {
                parent = (BoxImpl)this.boxes.get(pindex);
                box.setOffsetParent(parent);
            } else {
                log.error("Backend data error: the offset parent element <{}> is not available for <{}>.", (Object)pindex, (Object)boxInfo.getId());
            }
        } else {
            box.setOffsetParent(this.viewport);
        }
        if (boxInfo.getDomParent() != null) {
            pindex = boxInfo.getDomParent() + 1;
            if (pindex < this.boxes.size()) {
                parent = (BoxImpl)this.boxes.get(pindex);
                box.setDomParent(parent);
            } else {
                log.error("Backend data error: the DOM parent element <{}> is not available for <{}>.", (Object)pindex, (Object)boxInfo.getId());
            }
        } else {
            box.setDomParent(this.viewport);
        }
        if (box.isAbsolute()) {
            if (box.getOffsetParent() != null) {
                box.setIntrinsicParent((Box)box.getOffsetParent());
            } else {
                log.error("Backend data error: absolutely positioned box <{}> has no offset parent", (Object)box.getOrder());
            }
        } else if (box.isFixed()) {
            if (this.boxes.size() > 0) {
                box.setIntrinsicParent((Box)this.viewport);
            } else {
                log.warn("Backend data warning: root box <{}> has a fixed position", (Object)box.getOrder());
            }
        } else if (box.getDomParent() != null) {
            box.setIntrinsicParent((Box)box.getDomParent());
        } else if (this.boxes.size() > 0) {
            log.error("Backend data error: absolutely positioned box <{}> has no DOM parent", (Object)box.getOrder());
        }
    }

    private String getUsedFont(NodeData style, String fallback) {
        CSSProperty.FontFamily ff = (CSSProperty.FontFamily)style.getProperty("font-family");
        if (ff == CSSProperty.FontFamily.list_values) {
            TermList values = (TermList)style.getValue("font-family", false);
            for (Term value : values) {
                String name;
                if (!(value instanceof TermString) || !this.availFonts.contains(name = (String)((TermString)value).getValue()) && !this.defaultFonts.contains(name)) continue;
                return name;
            }
            return fallback;
        }
        if (ff != null) {
            return ff.toString();
        }
        return fallback;
    }

    private NodeData parseCss(String css) {
        String ssheet = "* { " + css + "}";
        NodeData style = CSSFactory.createNodeData();
        try {
            StyleSheet sheet = CSSFactory.parseString((String)ssheet, (URL)new URL("http://base.url"));
            RuleSet rule = (RuleSet)sheet.get(0);
            for (Declaration d : rule) {
                style.push(d);
            }
        }
        catch (CSSException e) {
            log.error("Couldn't parse inline css: {}", (Object)e.getMessage());
        }
        catch (MalformedURLException malformedURLException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return style;
    }

    private void loadImages(ImageInfo[] images) {
        for (ImageInfo img : images) {
            if (img.getData() == null || img.getBg() == null || img.getId() == null || img.getId() < 0 || img.getId() >= this.boxes.size()) continue;
            Box box = this.boxes.get(img.getId());
            try {
                byte[] imgdata = Base64.getDecoder().decode(img.getData());
                if (img.getBg().booleanValue()) {
                    ((BoxImpl)box).setBackgroundImagePng(imgdata);
                    continue;
                }
                DefaultContentImage cimg = new DefaultContentImage();
                cimg.setPngData(imgdata);
                ((BoxImpl)box).setContentObject((ContentObject)cimg);
            }
            catch (IllegalArgumentException e) {
                log.error("Couldn't decode background image for id={}", (Object)img.getId());
            }
        }
    }
}

