/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.layout.puppeteer;

import cz.vutbr.fit.layout.api.Parameter;
import cz.vutbr.fit.layout.api.ServiceException;
import cz.vutbr.fit.layout.impl.BaseArtifactService;
import cz.vutbr.fit.layout.impl.ParameterBoolean;
import cz.vutbr.fit.layout.impl.ParameterInt;
import cz.vutbr.fit.layout.impl.ParameterString;
import cz.vutbr.fit.layout.model.Artifact;
import cz.vutbr.fit.layout.model.Page;
import cz.vutbr.fit.layout.ontology.BOX;
import cz.vutbr.fit.layout.puppeteer.impl.BoxTreeBuilder;
import cz.vutbr.fit.layout.puppeteer.impl.PageImpl;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.rdf4j.model.IRI;

public class PuppeteerTreeProvider
extends BaseArtifactService {
    private String urlstring;
    private int width;
    private int height;
    private int persist;
    private boolean acquireImages;
    private boolean includeScreenshot;
    private boolean replaceImagesWithAlt;
    private BoxTreeBuilder builder;

    public PuppeteerTreeProvider() {
        this.urlstring = null;
        this.width = 1200;
        this.height = 800;
        this.persist = 1;
        this.acquireImages = false;
        this.includeScreenshot = true;
    }

    public PuppeteerTreeProvider(URL url, int width, int height) {
        this.urlstring = url.toString();
        this.width = width;
        this.height = height;
        this.persist = 1;
        this.acquireImages = false;
        this.includeScreenshot = true;
    }

    public PuppeteerTreeProvider(URL url, int width, int height, int persist, boolean acquireImages, boolean includeScreenshot) {
        this.urlstring = url.toString();
        this.width = width;
        this.height = height;
        this.persist = persist;
        this.acquireImages = acquireImages;
        this.includeScreenshot = includeScreenshot;
    }

    public String getId() {
        return "FitLayout.Puppeteer";
    }

    public String getName() {
        return "Puppeteer-based HTML renderer";
    }

    public String getDescription() {
        return "Uses the CSSBox rendering engine for obtaining the box tree.";
    }

    public List<Parameter> defineParams() {
        ArrayList<Parameter> ret = new ArrayList<Parameter>(6);
        ret.add((Parameter)new ParameterString("url", 0, 64));
        ret.add((Parameter)new ParameterInt("width", 10, 9999));
        ret.add((Parameter)new ParameterInt("height", 10, 9999));
        ret.add((Parameter)new ParameterInt("persist", 0, 3));
        ret.add((Parameter)new ParameterBoolean("acquireImages"));
        ret.add((Parameter)new ParameterBoolean("includeScreenshot"));
        return ret;
    }

    public String getUrl() {
        return this.urlstring;
    }

    public void setUrl(String url) {
        this.urlstring = new String(url);
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getPersist() {
        return this.persist;
    }

    public void setPersist(int persist) {
        this.persist = persist;
    }

    public boolean getAcquireImages() {
        return this.acquireImages;
    }

    public void setAcquireImages(boolean acquireImages) {
        this.acquireImages = acquireImages;
    }

    public boolean getIncludeScreenshot() {
        return this.includeScreenshot;
    }

    public void setIncludeScreenshot(boolean includeScreenshot) {
        this.includeScreenshot = includeScreenshot;
    }

    public boolean getReplaceImagesWithAlt() {
        return this.replaceImagesWithAlt;
    }

    public void setReplaceImagesWithAlt(boolean replaceImagesWithAlt) {
        this.replaceImagesWithAlt = replaceImagesWithAlt;
    }

    public IRI getConsumes() {
        return null;
    }

    public IRI getProduces() {
        return BOX.Page;
    }

    public Artifact process(Artifact input) throws ServiceException {
        if (this.urlstring == null || this.urlstring.isBlank()) {
            throw new ServiceException("No URL provided");
        }
        try {
            Page page = this.getPage();
            IRI pageIri = this.getServiceManager().getArtifactRepository().createArtifactIri((Artifact)page);
            page.setIri(pageIri);
            return page;
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
        catch (InterruptedException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public Page getPage() throws IOException, InterruptedException {
        this.builder = new BoxTreeBuilder(this.width, this.height, false, true);
        this.builder.setPersist(this.persist);
        this.builder.setAcquireImages(this.acquireImages);
        this.builder.setIncludeScreenshot(this.includeScreenshot);
        this.builder.parse(this.urlstring);
        PageImpl page = (PageImpl)this.builder.getPage();
        page.setCreator(this.getId());
        page.setCreatorParams(this.getParamString());
        return page;
    }
}

