/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.layout.puppeteer.impl;

import cz.vutbr.fit.layout.model.TextStyle;
import cz.vutbr.fit.layout.puppeteer.parser.BoxInfo;
import cz.vutbr.web.css.CSSProperty;
import cz.vutbr.web.css.NodeData;
import cz.vutbr.web.css.TermLength;

public class CSSTextStyle
extends TextStyle {
    public CSSTextStyle(BoxInfo src, NodeData style, int textLen) {
        CSSProperty.FontStyle fstyle;
        this.setContentLength(textLen);
        CSSProperty.FontSize fsize = (CSSProperty.FontSize)style.getProperty("font-size");
        if (fsize == CSSProperty.FontSize.length) {
            TermLength fsizeVal = (TermLength)style.getValue(TermLength.class, "font-size", false);
            this.setFontSizeSum(((Float)fsizeVal.getValue()).floatValue() * (float)textLen);
        } else {
            this.setFontSizeSum(12.0f * (float)textLen);
        }
        CSSProperty.FontWeight fweight = (CSSProperty.FontWeight)style.getProperty("font-weight");
        if (fweight != null) {
            switch (fweight) {
                case BOLD: 
                case BOLDER: 
                case numeric_600: 
                case numeric_700: 
                case numeric_800: 
                case numeric_900: {
                    this.setFontWeightSum(1 * textLen);
                    break;
                }
            }
        }
        if ((fstyle = (CSSProperty.FontStyle)style.getProperty("font-style")) == CSSProperty.FontStyle.ITALIC || fstyle == CSSProperty.FontStyle.OBLIQUE) {
            this.setFontStyleSum(1 * textLen);
        }
        if (src.getDecoration() != null) {
            if (src.getDecoration().contains("U")) {
                this.setUnderlineSum(1 * textLen);
            }
            if (src.getDecoration().contains("T")) {
                this.setLineThroughSum(1 * textLen);
            }
        }
    }
}

