/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.layout.puppeteer.impl;

import com.google.gson.Gson;
import cz.vutbr.fit.layout.json.impl.JSONBoxTreeBuilder;
import cz.vutbr.fit.layout.json.impl.StreamConsumer;
import cz.vutbr.fit.layout.json.parser.InputFile;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BoxTreeBuilder
extends JSONBoxTreeBuilder {
    private static final String PROP_BACKEND = "fitlayout.puppeteer.backend";
    private static final String PROP_WORKDIR = "fitlayout.puppeteer.workdir";
    private static final String PROP_WRAPPER = "fitlayout.puppeteer.wrapper";
    private static Logger log = LoggerFactory.getLogger(BoxTreeBuilder.class);
    public static final String DEFAULT_FONT_FAMILY = "sans-serif";
    public static final float DEFAULT_FONT_SIZE = 12.0f;
    private int width;
    private int height;
    private int persist;
    private boolean acquireImages;
    private boolean includeScreenshot;

    public BoxTreeBuilder(int width, int height, boolean useVisualBounds, boolean preserveAux) {
        super(useVisualBounds, preserveAux);
        this.width = width;
        this.height = height;
        this.persist = 1;
        this.acquireImages = false;
        this.includeScreenshot = true;
    }

    public void setPersist(int persist) {
        this.persist = persist;
    }

    public void setAcquireImages(boolean acquireImages) {
        this.acquireImages = acquireImages;
    }

    public void setIncludeScreenshot(boolean includeScreenshot) {
        this.includeScreenshot = includeScreenshot;
    }

    protected InputFile invokeRenderer(URL url) throws IOException, InterruptedException {
        String wrapper;
        String rendererPath = System.getProperty(PROP_BACKEND);
        if (rendererPath == null) {
            throw new IOException("Puppeteer backend path is not configured. Set the fitlayout.puppeteer.backend to point to the backend installation");
        }
        log.debug("Invoking puppeteer backend in {}", (Object)rendererPath);
        String workdir = System.getProperty(PROP_WORKDIR);
        if (workdir != null) {
            log.debug("Using chromium work directory {}", (Object)workdir);
        }
        String[] wrapArgs = (wrapper = System.getProperty(PROP_WRAPPER)) == null ? null : wrapper.split("\\s");
        ArrayList<String> cmds = new ArrayList<String>();
        if (wrapArgs != null) {
            for (String arg : wrapArgs) {
                cmds.add(arg);
            }
        }
        cmds.add("node");
        cmds.add("index.js");
        cmds.add("-W" + String.valueOf(this.width));
        cmds.add("-H" + String.valueOf(this.height));
        cmds.add("-P" + String.valueOf(this.persist));
        if (this.acquireImages) {
            cmds.add("-I");
        }
        if (this.includeScreenshot) {
            cmds.add("-s");
        }
        if (workdir != null) {
            cmds.add("-d'" + workdir + "'");
        }
        cmds.add(url.toString());
        if (wrapper != null) {
            cmds.add("-N");
        }
        ProcessBuilder pb = new ProcessBuilder(cmds);
        pb.directory(new File(rendererPath));
        final Process backend = pb.start();
        StreamConsumer outConsumer = new StreamConsumer(backend.getInputStream()){

            public Object consume(InputStream stream) {
                Gson gson = new Gson();
                BufferedReader outReader = new BufferedReader(new InputStreamReader(backend.getInputStream()));
                InputFile file = (InputFile)gson.fromJson((Reader)outReader, InputFile.class);
                return file;
            }
        };
        Future<?> futureOut = Executors.newSingleThreadExecutor().submit((Runnable)outConsumer);
        StreamConsumer errConsumer = new StreamConsumer(backend.getErrorStream()){

            public Object consume(InputStream stream) {
                BufferedReader errReader = new BufferedReader(new InputStreamReader(backend.getErrorStream()));
                StringBuilder builder = new StringBuilder();
                try {
                    String line;
                    while ((line = errReader.readLine()) != null) {
                        builder.append(line).append(System.getProperty("line.separator"));
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return builder.toString();
            }
        };
        Future<?> futureErr = Executors.newSingleThreadExecutor().submit((Runnable)errConsumer);
        int exitCode = backend.waitFor();
        try {
            futureOut.get();
            futureErr.get();
        }
        catch (ExecutionException e) {
            throw new IOException(e);
        }
        if (exitCode != 0) {
            String msg = (String)errConsumer.getResult();
            throw new IOException(msg);
        }
        InputFile file = (InputFile)outConsumer.getResult();
        return file;
    }
}

