/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.layout.segm;

import cz.vutbr.fit.layout.model.Area;
import cz.vutbr.fit.layout.model.Box;
import cz.vutbr.fit.layout.model.GenericTreeNode;
import cz.vutbr.fit.layout.model.Rectangular;
import java.util.Vector;

public class AreaUtils {
    public static boolean isNeighbor(Area a1, Area a2) {
        if (AreaUtils.isOnSameLine(a1, a2)) {
            return true;
        }
        int dy = a2.getBounds().getY1() - a1.getBounds().getY2();
        if (dy < 0) {
            dy = a1.getBounds().getY1() - a2.getBounds().getY2();
        }
        return dy < a1.getBounds().getHeight() / 2;
    }

    public static boolean isOnSameLine(Area a1, Area a2) {
        return AreaUtils.isOnSameLine(a1, a2, 1);
    }

    public static boolean isOnSameLine(Area a1, Area a2, int threshold) {
        Rectangular gp1 = a1.getBounds();
        Rectangular gp2 = a2.getBounds();
        return Math.abs(gp1.getY1() - gp2.getY1()) <= threshold && Math.abs(gp1.getY2() - gp2.getY2()) <= threshold;
    }

    public static boolean isOnSameLineRoughly(Area a1, Area a2) {
        Rectangular gp1 = a1.getBounds();
        Rectangular gp2 = a2.getBounds();
        return gp2.getY1() >= gp1.getY1() && gp2.getY1() < gp1.getY2() || gp2.getY2() > gp1.getY1() && gp2.getY2() <= gp1.getY2();
    }

    public static boolean isLink(Area a) {
        for (Box box : a.getBoxes()) {
            if (box.getAttribute("href") == null) continue;
            return true;
        }
        return false;
    }

    public static Area createSuperAreaFromVerticalRegion(Area root, Rectangular region) {
        int first = -1;
        int last = -1;
        Rectangular bounds = null;
        Vector<Area> selected = new Vector<Area>();
        for (int i = 0; i < root.getChildCount(); ++i) {
            Rectangular pos = ((Area)root.getChildAt(i)).getBounds();
            if (region.enclosesY(pos)) {
                if (first == -1) {
                    first = i;
                }
                last = i;
                selected.add((Area)root.getChildAt(i));
                if (bounds == null) {
                    bounds = new Rectangular(pos);
                    continue;
                }
                bounds.expandToEnclose(pos);
                continue;
            }
            if (first != -1) break;
        }
        if (last > first) {
            Area ret = root.getAreaTree().createArea(bounds);
            root.insertChild((GenericTreeNode)ret, first);
            for (Area a : selected) {
                ret.appendChild((GenericTreeNode)a);
            }
            root.updateTopologies();
            ret.updateTopologies();
            return ret;
        }
        return null;
    }
}

