/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.layout.segm;

import cz.vutbr.fit.layout.model.Area;
import cz.vutbr.fit.layout.model.ContentRect;
import cz.vutbr.fit.layout.segm.Config;
import cz.vutbr.fit.layout.segm.op.Separator;
import cz.vutbr.fit.layout.segm.op.SeparatorSet;
import java.util.Iterator;
import java.util.List;

public class Separators {
    public static final String ATTR_SEPARATORS = "segm.seps";

    public static void createSeparatorsForArea(Area area) {
        SeparatorSet seps = Config.createSeparators(area);
        area.addUserAttribute(ATTR_SEPARATORS, (Object)seps);
    }

    public static SeparatorSet getSeparatorsForArea(Area area) {
        return (SeparatorSet)area.getUserAttribute(ATTR_SEPARATORS, SeparatorSet.class);
    }

    public static void removeSimpleSeparators(Area area) {
        SeparatorSet seps = Separators.getSeparatorsForArea(area);
        Separators.removeSimpleSeparators(area, seps.getHorizontal());
        Separators.removeSimpleSeparators(area, seps.getVertical());
        Separators.removeSimpleSeparators(area, seps.getBoxsep());
    }

    private static void removeSimpleSeparators(Area area, List<Separator> v) {
        Iterator<Separator> it = v.iterator();
        while (it.hasNext()) {
            int b;
            int a;
            Separator sep = it.next();
            if (sep.getType() == 0 || sep.getType() == 2) {
                a = Separators.countAreasAbove(area, sep);
                b = Separators.countAreasBelow(area, sep);
                if (a > 1 || b > 1) continue;
                it.remove();
                continue;
            }
            a = Separators.countAreasLeft(area, sep);
            b = Separators.countAreasRight(area, sep);
            if (a > 1 || b > 1) continue;
            it.remove();
        }
    }

    private static int countAreasAbove(Area a, Separator sep) {
        int gx1 = a.getTopology().toTopologyX(sep.getX1());
        int gx2 = a.getTopology().toTopologyX(sep.getX2());
        int gy = a.getTopology().toTopologyY(sep.getY1() - 1);
        int ret = 0;
        if (gx1 >= 0 && gx2 >= 0 && gy >= 0) {
            int i = gx1;
            while (i <= gx2) {
                Area node = (Area)a.getTopology().findAreaAt(i, gy);
                if (node != null) {
                    ++ret;
                    i += a.getTopology().getPosition((ContentRect)node).getWidth();
                    continue;
                }
                ++i;
            }
        }
        return ret;
    }

    private static int countAreasBelow(Area a, Separator sep) {
        int gx1 = a.getTopology().toTopologyX(sep.getX1());
        int gx2 = a.getTopology().toTopologyX(sep.getX2());
        int gy = a.getTopology().toTopologyY(sep.getY2() + 1);
        int ret = 0;
        if (gx1 >= 0 && gx2 >= 0 && gy >= 0) {
            int i = gx1;
            while (i <= gx2) {
                Area node = (Area)a.getTopology().findAreaAt(i, gy);
                if (node != null) {
                    ++ret;
                    i += a.getTopology().getPosition((ContentRect)node).getWidth();
                    continue;
                }
                ++i;
            }
        }
        return ret;
    }

    private static int countAreasLeft(Area a, Separator sep) {
        int gy1 = a.getTopology().toTopologyY(sep.getY1());
        int gy2 = a.getTopology().toTopologyY(sep.getY2());
        int gx = a.getTopology().toTopologyX(sep.getX1() - 1);
        int ret = 0;
        if (gy1 >= 0 && gy2 >= 0 && gx >= 0) {
            int i = gy1;
            while (i <= gy2) {
                Area node = (Area)a.getTopology().findAreaAt(gx, i);
                if (node != null) {
                    ++ret;
                    i += a.getTopology().getPosition((ContentRect)node).getWidth();
                    continue;
                }
                ++i;
            }
        }
        return ret;
    }

    private static int countAreasRight(Area a, Separator sep) {
        int gy1 = a.getTopology().toTopologyY(sep.getY1());
        int gy2 = a.getTopology().toTopologyY(sep.getY2());
        int gx = a.getTopology().toTopologyX(sep.getX2() + 1);
        int ret = 0;
        if (gy1 >= 0 && gy2 >= 0 && gx >= 0) {
            int i = gy1;
            while (i <= gy2) {
                Area node = (Area)a.getTopology().findAreaAt(gx, i);
                if (node != null) {
                    ++ret;
                    i += a.getTopology().getPosition((ContentRect)node).getWidth();
                    continue;
                }
                ++i;
            }
        }
        return ret;
    }
}

