/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.layout.segm.op;

import cz.vutbr.fit.layout.impl.BaseOperator;
import cz.vutbr.fit.layout.model.Area;
import cz.vutbr.fit.layout.model.AreaTree;
import cz.vutbr.fit.layout.model.GenericTreeNode;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class FlattenTreeOperator
extends BaseOperator {
    public String getId() {
        return "FitLayout.Segm.FlattenTree";
    }

    public String getName() {
        return "Flatten tree";
    }

    public String getDescription() {
        return "Flattens the tree: only the root area and the leaf areas are preserved.";
    }

    public String getCategory() {
        return "Restructure";
    }

    public void apply(AreaTree atree) {
        this.apply(atree, atree.getRoot());
    }

    public void apply(AreaTree atree, Area root) {
        LinkedList<Area> addList = new LinkedList<Area>();
        LinkedList<Area> removeList = new LinkedList<Area>();
        this.scanAreas(root, addList, removeList);
        for (Area area : addList) {
            root.appendChild((GenericTreeNode)area);
        }
        this.removeAreas(root, removeList);
    }

    private void scanAreas(Area root, List<Area> addList, List<Area> removeList) {
        if (root.getParent() != null) {
            if (root.isLeaf()) {
                addList.add(root);
            } else {
                removeList.add(root);
            }
        }
        for (Area child : root.getChildren()) {
            this.scanAreas(child, addList, removeList);
        }
    }

    private void removeAreas(Area root, List<Area> toRemove) {
        ArrayList curChildren = new ArrayList(root.getChildren());
        for (Area child : curChildren) {
            this.removeAreas(child, toRemove);
        }
        for (Area child : curChildren) {
            if (!toRemove.contains(child)) continue;
            root.removeChild((GenericTreeNode)child);
        }
        root.updateTopologies();
    }
}

