/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.layout.segm.op;

import cz.vutbr.fit.layout.model.Area;
import cz.vutbr.fit.layout.model.AreaTopology;
import cz.vutbr.fit.layout.model.ContentRect;
import cz.vutbr.fit.layout.model.Rectangular;
import cz.vutbr.fit.layout.segm.AreaStyle;
import cz.vutbr.fit.layout.segm.Separators;
import cz.vutbr.fit.layout.segm.op.GroupAnalyzer;
import cz.vutbr.fit.layout.segm.op.SeparatorSet;
import java.util.ArrayList;
import java.util.List;

public class GroupAnalyzerByStyles
extends GroupAnalyzer {
    private static final short DIR_DOWN = 0;
    private static final short DIR_UP = 1;
    private static final short DIR_RIGHT = 2;
    private static final short DIR_LEFT = 3;
    private static final short REQ_BOTH = 0;
    private static final short REQ_HORIZONTAL = 1;
    private static final short REQ_VERTICAL = 2;
    private SeparatorSet seps = null;
    private int maxlevel;
    private boolean matchstyles;

    public GroupAnalyzerByStyles(Area parent, int maxlevel, boolean matchstyles) {
        super(parent);
        this.maxlevel = maxlevel;
        this.matchstyles = matchstyles;
    }

    @Override
    public Area findSuperArea(Area sub, List<Area> selected) {
        this.seps = Separators.getSeparatorsForArea(this.parent);
        AreaTopology t = this.parent.getTopology();
        Rectangular gp = new Rectangular(sub.getGridPosition());
        System.out.println("GSS************* Start: " + gp + " - " + sub);
        Rectangular limit = new Rectangular(0, 0, this.getTopology().getTopologyWidth() - 1, this.getTopology().getTopologyHeight() - 1);
        this.expandToLimit(sub, gp, limit, sub, true, true, (short)2, (short)0);
        selected.clear();
        Rectangular mingp = null;
        for (int i = 0; i < this.parent.getChildCount(); ++i) {
            Area chld = (Area)this.parent.getChildAt(i);
            Rectangular cgp = t.getPosition((ContentRect)chld);
            if (!gp.encloses(cgp)) continue;
            selected.add(chld);
            if (mingp == null) {
                mingp = new Rectangular(cgp);
                continue;
            }
            mingp.expandToEnclose(cgp);
        }
        Rectangular abspos = this.getTopology().toPixelPosition(mingp);
        abspos.move(this.parent.getX1(), this.parent.getY1());
        Area area = sub.getAreaTree().createArea(abspos);
        area.setLevel(1);
        area.setGridPosition(mingp);
        return area;
    }

    private void expandToLimit(Area sub, Rectangular gp, Rectangular limit, Area template, boolean hsep, boolean vsep, short prefDir, short required) {
        System.out.println("  Expand " + sub + " DIR=" + (short)prefDir + " sep=" + hsep + ":" + vsep);
        if (this.getTopology().getTopologyWidth() > 0 && this.getTopology().getTopologyHeight() > 0 && !sub.isBackgroundSeparated()) {
            int dir = prefDir;
            int attempts = 0;
            while (attempts < 4 && !this.limitReached(gp, limit, required)) {
                boolean change = false;
                switch (dir) {
                    case 0: {
                        int newy;
                        if (gp.getY2() >= limit.getY2() || hsep && this.separatorDown(sub.getGridPosition().replaceY(gp)) || (newy = this.expandVertically(gp, limit, template, true, hsep)) <= gp.getY2()) break;
                        gp.setY2(newy);
                        change = true;
                        break;
                    }
                    case 2: {
                        int newx;
                        if (gp.getX2() >= limit.getX2() || vsep && this.separatorRight(sub.getGridPosition().replaceX(gp)) || (newx = this.expandHorizontally(gp, limit, template, true, vsep)) <= gp.getX2()) break;
                        gp.setX2(newx);
                        change = true;
                        break;
                    }
                    case 1: {
                        int newy;
                        if (gp.getY1() <= limit.getY1() || hsep && this.separatorUp(sub.getGridPosition().replaceY(gp)) || (newy = this.expandVertically(gp, limit, template, false, hsep)) >= gp.getY1()) break;
                        gp.setY1(newy);
                        change = true;
                        break;
                    }
                    case 3: {
                        int newx;
                        if (gp.getX1() <= limit.getX1() || vsep && this.separatorLeft(sub.getGridPosition().replaceX(gp)) || (newx = this.expandHorizontally(gp, limit, template, false, vsep)) >= gp.getX1()) break;
                        gp.setX1(newx);
                        change = true;
                    }
                }
                if (!change) {
                    if (++dir >= 4) {
                        dir = 0;
                    }
                    ++attempts;
                    continue;
                }
                attempts = 0;
            }
        }
    }

    private boolean limitReached(Rectangular gp, Rectangular limit, short required) {
        switch (required) {
            case 1: {
                return gp.getX1() <= limit.getX1() && gp.getX2() >= limit.getX2();
            }
            case 2: {
                return gp.getY1() <= limit.getY1() && gp.getY2() >= limit.getY2();
            }
            case 0: {
                return gp.getX1() <= limit.getX1() && gp.getX2() >= limit.getX2() && gp.getY1() <= limit.getY1() && gp.getY2() >= limit.getY2();
            }
        }
        return false;
    }

    private int expandVertically(Rectangular gp, Rectangular limit, Area template, boolean down, boolean sep) {
        int na = down ? gp.getY2() : gp.getY1();
        int targety = down ? gp.getY2() + 1 : gp.getY1() - 1;
        ArrayList<Area> cands = new ArrayList<Area>();
        int x = gp.getX1();
        while (x <= gp.getX2()) {
            Area cand = (Area)this.getTopology().findAreaAt(x, targety);
            if (cand == null || cand.getGridPosition().intersects(gp)) {
                ++x;
                continue;
            }
            cands.add(cand);
            x = cand.getGridPosition().getX2() + 1;
        }
        if (cands.size() == 0) {
            return targety;
        }
        for (Area cand : cands) {
            Rectangular newlimit;
            if (sep && (down && this.separatorUp(cand.getGridPosition()) || !down && this.separatorDown(cand.getGridPosition()))) {
                return na;
            }
            if (this.matchstyles && !AreaStyle.hasSameStyle(template, cand) || cand.getLevel() > this.maxlevel) {
                return na;
            }
            Rectangular cgp = new Rectangular(cand.getGridPosition());
            if (cgp.getX1() == gp.getX1() && cgp.getX2() == gp.getX2()) {
                return targety;
            }
            if (cgp.getX1() < gp.getX1() || cgp.getX2() > gp.getX2()) {
                return na;
            }
            if (down) {
                newlimit = new Rectangular(gp.getX1(), targety, gp.getX2(), limit.getY2());
                this.expandToLimit(cand, cgp, newlimit, template, true, false, (short)2, (short)1);
                if (cgp.getX1() != gp.getX1() || cgp.getX2() != gp.getX2()) continue;
                return cgp.getY2();
            }
            newlimit = new Rectangular(gp.getX1(), limit.getY1(), gp.getX2(), targety);
            this.expandToLimit(cand, cgp, newlimit, template, true, false, (short)2, (short)1);
            if (cgp.getX1() != gp.getX1() || cgp.getX2() != gp.getX2()) continue;
            return cgp.getY1();
        }
        return na;
    }

    private int expandHorizontally(Rectangular gp, Rectangular limit, Area template, boolean right, boolean sep) {
        int na = right ? gp.getX2() : gp.getX1();
        int targetx = right ? gp.getX2() + 1 : gp.getX1() - 1;
        boolean found = false;
        int y = gp.getY1();
        while (y <= gp.getY2()) {
            Area cand = (Area)this.getTopology().findAreaAt(targetx, y);
            if (cand != null && !cand.getGridPosition().intersects(gp)) {
                Rectangular newlimit;
                found = true;
                if (sep && (right && this.separatorLeft(cand.getGridPosition()) || !right && this.separatorRight(cand.getGridPosition()))) {
                    return na;
                }
                if (this.matchstyles && !AreaStyle.hasSameStyle(template, cand) || cand.getLevel() > this.maxlevel) {
                    return na;
                }
                Rectangular cgp = new Rectangular(cand.getGridPosition());
                if (cgp.getY1() == gp.getY1() && cgp.getY2() == gp.getY2()) {
                    return targetx;
                }
                if (cgp.getY1() < gp.getY1() || cgp.getY2() > gp.getY2()) {
                    return na;
                }
                if (right) {
                    newlimit = new Rectangular(targetx, gp.getY1(), limit.getX2(), gp.getY2());
                    this.expandToLimit(cand, cgp, newlimit, template, false, true, (short)0, (short)2);
                    if (cgp.getY1() == gp.getY1() && cgp.getY2() == gp.getY2()) {
                        return cgp.getX2();
                    }
                } else {
                    newlimit = new Rectangular(limit.getX1(), gp.getY1(), targetx, gp.getY2());
                    this.expandToLimit(cand, cgp, newlimit, template, false, true, (short)0, (short)2);
                    if (cgp.getY1() == gp.getY1() && cgp.getY2() == gp.getY2()) {
                        return cgp.getX1();
                    }
                }
                y += cand.getGridPosition().getY2() + 1;
                continue;
            }
            ++y;
        }
        if (!found) {
            return targetx;
        }
        return na;
    }

    private boolean separatorDown(Rectangular pos) {
        if (pos.getY2() < this.getTopology().getTopologyHeight() - 1) {
            Rectangular spos = this.getTopology().toPixelPositionAbsolute(new Rectangular(pos.getX1(), pos.getY2(), pos.getX2(), pos.getY2()));
            Rectangular epos = this.getTopology().toPixelPositionAbsolute(new Rectangular(pos.getX1(), pos.getY2() + 1, pos.getX2(), pos.getY2() + 1));
            return this.seps.isSeparatorAt(spos.midX(), spos.getY2()) || this.seps.isSeparatorAt(epos.midX(), epos.getY1());
        }
        return true;
    }

    private boolean separatorUp(Rectangular pos) {
        if (pos.getY1() > 0) {
            Rectangular spos = this.getTopology().toPixelPositionAbsolute(new Rectangular(pos.getX1(), pos.getY1(), pos.getX2(), pos.getY1()));
            Rectangular epos = this.getTopology().toPixelPositionAbsolute(new Rectangular(pos.getX1(), pos.getY1() - 1, pos.getX2(), pos.getY1() - 1));
            return this.seps.isSeparatorAt(spos.midX(), spos.getY1()) || this.seps.isSeparatorAt(epos.midX(), epos.getY2());
        }
        return true;
    }

    private boolean separatorLeft(Rectangular pos) {
        if (pos.getX1() > 0) {
            Rectangular spos = this.getTopology().toPixelPositionAbsolute(new Rectangular(pos.getX1(), pos.getY1(), pos.getX1(), pos.getY2()));
            Rectangular epos = this.getTopology().toPixelPositionAbsolute(new Rectangular(pos.getX1() - 1, pos.getY1(), pos.getX1() - 1, pos.getY2()));
            return this.seps.isSeparatorAt(spos.getX1(), spos.midY()) || this.seps.isSeparatorAt(epos.getX2(), epos.midY());
        }
        return true;
    }

    private boolean separatorRight(Rectangular pos) {
        if (pos.getX2() < this.getTopology().getTopologyWidth() - 1) {
            Rectangular spos = this.getTopology().toPixelPositionAbsolute(new Rectangular(pos.getX2(), pos.getY1(), pos.getX2(), pos.getY2()));
            Rectangular epos = this.getTopology().toPixelPositionAbsolute(new Rectangular(pos.getX2() + 1, pos.getY1(), pos.getX2() + 1, pos.getY2()));
            return this.seps.isSeparatorAt(spos.getX2(), spos.midY()) || this.seps.isSeparatorAt(epos.getX1(), epos.midY());
        }
        return true;
    }
}

