/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.layout.segm.op;

import cz.vutbr.fit.layout.api.Parameter;
import cz.vutbr.fit.layout.impl.BaseOperator;
import cz.vutbr.fit.layout.impl.ParameterBoolean;
import cz.vutbr.fit.layout.impl.ParameterFloat;
import cz.vutbr.fit.layout.model.Area;
import cz.vutbr.fit.layout.model.AreaTopology;
import cz.vutbr.fit.layout.model.AreaTree;
import cz.vutbr.fit.layout.model.ContentRect;
import cz.vutbr.fit.layout.model.GenericTreeNode;
import cz.vutbr.fit.layout.model.Rectangular;
import cz.vutbr.fit.layout.segm.AreaStyle;
import cz.vutbr.fit.layout.segm.TreeOp;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiLineOperator
extends BaseOperator {
    private static Logger log = LoggerFactory.getLogger(MultiLineOperator.class);
    protected boolean useConsistentStyle;
    protected float maxLineEmSpace;

    public MultiLineOperator() {
        this.useConsistentStyle = false;
        this.maxLineEmSpace = 1.5f;
    }

    public MultiLineOperator(boolean useConsistentStyle, float maxLineEmSpace) {
        this.useConsistentStyle = useConsistentStyle;
        this.maxLineEmSpace = maxLineEmSpace;
    }

    public String getId() {
        return "FitLayout.Segm.MultiLine";
    }

    public String getName() {
        return "Group aligned lines";
    }

    public String getDescription() {
        return "Detects sequences of aligned lines and joins them to a single area.";
    }

    public String getCategory() {
        return "Lines";
    }

    public List<Parameter> defineParams() {
        ArrayList<Parameter> ret = new ArrayList<Parameter>();
        ret.add((Parameter)new ParameterBoolean("useConsistentStyle"));
        ret.add((Parameter)new ParameterFloat("maxLineEmSpace"));
        return ret;
    }

    public boolean getUseConsistentStyle() {
        return this.useConsistentStyle;
    }

    public void setUseConsistentStyle(boolean useConsistentStyle) {
        this.useConsistentStyle = useConsistentStyle;
    }

    public float getMaxLineEmSpace() {
        return this.maxLineEmSpace;
    }

    public void setMaxLineEmSpace(float maxLineEmSpace) {
        this.maxLineEmSpace = maxLineEmSpace;
    }

    public void apply(AreaTree atree) {
        this.recursiveJoinAreas(atree.getRoot());
    }

    public void apply(AreaTree atree, Area root) {
        this.recursiveJoinAreas(root);
    }

    protected void recursiveJoinAreas(Area root) {
        this.joinAreas(root);
        for (int i = 0; i < root.getChildCount(); ++i) {
            this.recursiveJoinAreas((Area)root.getChildAt(i));
        }
    }

    protected void joinAreas(Area a) {
        AreaTopology t = a.getTopology();
        boolean change = true;
        block0: while (change) {
            change = false;
            for (int i = 0; i < a.getChildCount(); ++i) {
                Area node = (Area)a.getChildAt(i);
                Rectangular pos = t.getPosition((ContentRect)node);
                int nx1 = pos.getX1();
                int nx2 = pos.getX2();
                int ny2 = pos.getY2();
                Area neigh = null;
                int dist = 1;
                while (neigh == null && ny2 + dist < t.getTopologyHeight()) {
                    for (int x = nx1; neigh == null && x <= nx2; ++x) {
                        neigh = (Area)t.findAreaAt(x, ny2 + dist);
                        if (neigh == null || this.useConsistentStyle && !AreaStyle.hasSameStyle(node, neigh) || neigh.getGridPosition().getX1() != nx1 || !this.verticalJoin(a, node, neigh, true)) continue;
                        node.updateTopologies();
                        change = true;
                    }
                    ++dist;
                }
                if (change) continue block0;
            }
        }
    }

    private boolean verticalJoin(Area parent, Area n1, Area n2, boolean affect) {
        int dist = Math.min(Math.abs(n2.getY1() - n1.getY2()), Math.abs(n1.getY1() - n2.getY2()));
        if ((float)dist > n1.getTextStyle().getFontSize() * this.maxLineEmSpace) {
            return false;
        }
        if (n1.hasBottomBorder() || n2.hasTopBorder() || !AreaStyle.hasEqualBackground(n1, n2)) {
            return false;
        }
        int sx1 = n1.getGridPosition().getX1();
        int sx2 = n2.getGridPosition().getX1();
        while (sx1 != sx2) {
            if (sx1 < sx2) {
                if (sx2 > 0 && this.canExpandX(parent, n2, sx2 - 1, n1)) {
                    --sx2;
                    continue;
                }
                return false;
            }
            if (sx1 <= sx2) continue;
            if (sx1 > 0 && this.canExpandX(parent, n1, sx1 - 1, n2)) {
                --sx1;
                continue;
            }
            return false;
        }
        int ex1 = n1.getGridPosition().getX2();
        int ex2 = n2.getGridPosition().getX2();
        while (ex1 != ex2) {
            if (ex1 < ex2) {
                if (ex1 < parent.getTopology().getTopologyHeight() - 1 && this.canExpandX(parent, n1, ex1 + 1, n2)) {
                    ++ex1;
                    continue;
                }
                return false;
            }
            if (ex1 <= ex2) continue;
            if (ex2 < parent.getTopology().getTopologyHeight() - 1 && this.canExpandX(parent, n2, ex2 + 1, n1)) {
                ++ex2;
                continue;
            }
            return false;
        }
        if (affect) {
            log.debug("VJoin: {} + {}", (Object)n1, (Object)n2);
            Rectangular newpos = new Rectangular(sx1, n1.getGridPosition().getY1(), ex1, n2.getGridPosition().getY2());
            TreeOp.joinArea(n1, n2, newpos, true);
            parent.removeChild((GenericTreeNode)n2);
        }
        return true;
    }

    private boolean canExpandX(Area parent, Area node, int x, Area except) {
        AreaTopology t = parent.getTopology();
        int gy = t.getPosition((ContentRect)node).getY1();
        int gh = t.getTopologyHeight();
        for (int y = gy; y < gy + gh; ++y) {
            Area cand = (Area)t.findAreaAt(x, y);
            if (cand == null || cand == except) continue;
            return false;
        }
        return true;
    }
}

